/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.NetworkingV1beta1IngressBackend;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.")
public class NetworkingV1beta1HTTPIngressPath {
    public static final String SERIALIZED_NAME_BACKEND = "backend";
    @SerializedName(value="backend")
    private NetworkingV1beta1IngressBackend backend;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;

    public NetworkingV1beta1HTTPIngressPath backend(NetworkingV1beta1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkingV1beta1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(NetworkingV1beta1IngressBackend backend) {
        this.backend = backend;
    }

    public NetworkingV1beta1HTTPIngressPath path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional \"path\" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkingV1beta1HTTPIngressPath networkingV1beta1HTTPIngressPath = (NetworkingV1beta1HTTPIngressPath)o;
        return Objects.equals(this.backend, networkingV1beta1HTTPIngressPath.backend) && Objects.equals(this.path, networkingV1beta1HTTPIngressPath.path);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkingV1beta1HTTPIngressPath {\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

