package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ControllerRevisionListBuilder extends V1beta2ControllerRevisionListFluentImpl<V1beta2ControllerRevisionListBuilder> implements VisitableBuilder<V1beta2ControllerRevisionList,V1beta2ControllerRevisionListBuilder>{

    V1beta2ControllerRevisionListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2ControllerRevisionListBuilder(){
            this(true);
    }
    public V1beta2ControllerRevisionListBuilder(Boolean validationEnabled){
            this(new V1beta2ControllerRevisionList(), validationEnabled);
    }
    public V1beta2ControllerRevisionListBuilder(V1beta2ControllerRevisionListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2ControllerRevisionListBuilder(V1beta2ControllerRevisionListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2ControllerRevisionList(), validationEnabled);
    }
    public V1beta2ControllerRevisionListBuilder(V1beta2ControllerRevisionListFluent<?> fluent,V1beta2ControllerRevisionList instance){
            this(fluent, instance, true);
    }
    public V1beta2ControllerRevisionListBuilder(V1beta2ControllerRevisionListFluent<?> fluent,V1beta2ControllerRevisionList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2ControllerRevisionListBuilder(V1beta2ControllerRevisionList instance){
            this(instance,true);
    }
    public V1beta2ControllerRevisionListBuilder(V1beta2ControllerRevisionList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2ControllerRevisionList build(){
            V1beta2ControllerRevisionList buildable = new V1beta2ControllerRevisionList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ControllerRevisionListBuilder that = (V1beta2ControllerRevisionListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
