package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1SubjectBuilder extends V1beta1SubjectFluentImpl<V1beta1SubjectBuilder> implements VisitableBuilder<V1beta1Subject,V1beta1SubjectBuilder>{

    V1beta1SubjectFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1SubjectBuilder(){
            this(true);
    }
    public V1beta1SubjectBuilder(Boolean validationEnabled){
            this(new V1beta1Subject(), validationEnabled);
    }
    public V1beta1SubjectBuilder(V1beta1SubjectFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1SubjectBuilder(V1beta1SubjectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1Subject(), validationEnabled);
    }
    public V1beta1SubjectBuilder(V1beta1SubjectFluent<?> fluent,V1beta1Subject instance){
            this(fluent, instance, true);
    }
    public V1beta1SubjectBuilder(V1beta1SubjectFluent<?> fluent,V1beta1Subject instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroup(instance.getApiGroup());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1SubjectBuilder(V1beta1Subject instance){
            this(instance,true);
    }
    public V1beta1SubjectBuilder(V1beta1Subject instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroup(instance.getApiGroup());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1Subject build(){
            V1beta1Subject buildable = new V1beta1Subject();
            buildable.setApiGroup(fluent.getApiGroup());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1SubjectBuilder that = (V1beta1SubjectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
