package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1RuntimeClassSpecBuilder extends V1alpha1RuntimeClassSpecFluentImpl<V1alpha1RuntimeClassSpecBuilder> implements VisitableBuilder<V1alpha1RuntimeClassSpec,V1alpha1RuntimeClassSpecBuilder>{

    V1alpha1RuntimeClassSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1RuntimeClassSpecBuilder(){
            this(true);
    }
    public V1alpha1RuntimeClassSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1RuntimeClassSpec(), validationEnabled);
    }
    public V1alpha1RuntimeClassSpecBuilder(V1alpha1RuntimeClassSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1RuntimeClassSpecBuilder(V1alpha1RuntimeClassSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1RuntimeClassSpec(), validationEnabled);
    }
    public V1alpha1RuntimeClassSpecBuilder(V1alpha1RuntimeClassSpecFluent<?> fluent,V1alpha1RuntimeClassSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1RuntimeClassSpecBuilder(V1alpha1RuntimeClassSpecFluent<?> fluent,V1alpha1RuntimeClassSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRuntimeHandler(instance.getRuntimeHandler());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1RuntimeClassSpecBuilder(V1alpha1RuntimeClassSpec instance){
            this(instance,true);
    }
    public V1alpha1RuntimeClassSpecBuilder(V1alpha1RuntimeClassSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRuntimeHandler(instance.getRuntimeHandler());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1RuntimeClassSpec build(){
            V1alpha1RuntimeClassSpec buildable = new V1alpha1RuntimeClassSpec();
            buildable.setRuntimeHandler(fluent.getRuntimeHandler());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RuntimeClassSpecBuilder that = (V1alpha1RuntimeClassSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
