package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1StorageOSVolumeSourceBuilder extends V1StorageOSVolumeSourceFluentImpl<V1StorageOSVolumeSourceBuilder> implements VisitableBuilder<V1StorageOSVolumeSource,V1StorageOSVolumeSourceBuilder>{

    V1StorageOSVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1StorageOSVolumeSourceBuilder(){
            this(true);
    }
    public V1StorageOSVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1StorageOSVolumeSource(), validationEnabled);
    }
    public V1StorageOSVolumeSourceBuilder(V1StorageOSVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1StorageOSVolumeSourceBuilder(V1StorageOSVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1StorageOSVolumeSource(), validationEnabled);
    }
    public V1StorageOSVolumeSourceBuilder(V1StorageOSVolumeSourceFluent<?> fluent,V1StorageOSVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1StorageOSVolumeSourceBuilder(V1StorageOSVolumeSourceFluent<?> fluent,V1StorageOSVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsType(instance.getFsType());

            fluent.withReadOnly(instance.getReadOnly());

            fluent.withSecretRef(instance.getSecretRef());

            fluent.withVolumeName(instance.getVolumeName());

            fluent.withVolumeNamespace(instance.getVolumeNamespace());

            this.validationEnabled = validationEnabled; 
    }
    public V1StorageOSVolumeSourceBuilder(V1StorageOSVolumeSource instance){
            this(instance,true);
    }
    public V1StorageOSVolumeSourceBuilder(V1StorageOSVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsType(instance.getFsType());

            this.withReadOnly(instance.getReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.withVolumeName(instance.getVolumeName());

            this.withVolumeNamespace(instance.getVolumeNamespace());

            this.validationEnabled = validationEnabled; 
    }

    public V1StorageOSVolumeSource build(){
            V1StorageOSVolumeSource buildable = new V1StorageOSVolumeSource();
            buildable.setFsType(fluent.getFsType());
            buildable.setReadOnly(fluent.isReadOnly());
            buildable.setSecretRef(fluent.getSecretRef());
            buildable.setVolumeName(fluent.getVolumeName());
            buildable.setVolumeNamespace(fluent.getVolumeNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1StorageOSVolumeSourceBuilder that = (V1StorageOSVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
