package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SELinuxOptionsBuilder extends V1SELinuxOptionsFluentImpl<V1SELinuxOptionsBuilder> implements VisitableBuilder<V1SELinuxOptions,V1SELinuxOptionsBuilder>{

    V1SELinuxOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1SELinuxOptionsBuilder(){
            this(true);
    }
    public V1SELinuxOptionsBuilder(Boolean validationEnabled){
            this(new V1SELinuxOptions(), validationEnabled);
    }
    public V1SELinuxOptionsBuilder(V1SELinuxOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1SELinuxOptionsBuilder(V1SELinuxOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1SELinuxOptions(), validationEnabled);
    }
    public V1SELinuxOptionsBuilder(V1SELinuxOptionsFluent<?> fluent,V1SELinuxOptions instance){
            this(fluent, instance, true);
    }
    public V1SELinuxOptionsBuilder(V1SELinuxOptionsFluent<?> fluent,V1SELinuxOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLevel(instance.getLevel());

            fluent.withRole(instance.getRole());

            fluent.withType(instance.getType());

            fluent.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }
    public V1SELinuxOptionsBuilder(V1SELinuxOptions instance){
            this(instance,true);
    }
    public V1SELinuxOptionsBuilder(V1SELinuxOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLevel(instance.getLevel());

            this.withRole(instance.getRole());

            this.withType(instance.getType());

            this.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }

    public V1SELinuxOptions build(){
            V1SELinuxOptions buildable = new V1SELinuxOptions();
            buildable.setLevel(fluent.getLevel());
            buildable.setRole(fluent.getRole());
            buildable.setType(fluent.getType());
            buildable.setUser(fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SELinuxOptionsBuilder that = (V1SELinuxOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
