package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodStatusBuilder extends V1PodStatusFluentImpl<V1PodStatusBuilder> implements VisitableBuilder<V1PodStatus,V1PodStatusBuilder>{

    V1PodStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodStatusBuilder(){
            this(true);
    }
    public V1PodStatusBuilder(Boolean validationEnabled){
            this(new V1PodStatus(), validationEnabled);
    }
    public V1PodStatusBuilder(V1PodStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodStatusBuilder(V1PodStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodStatus(), validationEnabled);
    }
    public V1PodStatusBuilder(V1PodStatusFluent<?> fluent,V1PodStatus instance){
            this(fluent, instance, true);
    }
    public V1PodStatusBuilder(V1PodStatusFluent<?> fluent,V1PodStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions());

            fluent.withContainerStatuses(instance.getContainerStatuses());

            fluent.withHostIP(instance.getHostIP());

            fluent.withInitContainerStatuses(instance.getInitContainerStatuses());

            fluent.withMessage(instance.getMessage());

            fluent.withNominatedNodeName(instance.getNominatedNodeName());

            fluent.withPhase(instance.getPhase());

            fluent.withPodIP(instance.getPodIP());

            fluent.withQosClass(instance.getQosClass());

            fluent.withReason(instance.getReason());

            fluent.withStartTime(instance.getStartTime());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodStatusBuilder(V1PodStatus instance){
            this(instance,true);
    }
    public V1PodStatusBuilder(V1PodStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions());

            this.withContainerStatuses(instance.getContainerStatuses());

            this.withHostIP(instance.getHostIP());

            this.withInitContainerStatuses(instance.getInitContainerStatuses());

            this.withMessage(instance.getMessage());

            this.withNominatedNodeName(instance.getNominatedNodeName());

            this.withPhase(instance.getPhase());

            this.withPodIP(instance.getPodIP());

            this.withQosClass(instance.getQosClass());

            this.withReason(instance.getReason());

            this.withStartTime(instance.getStartTime());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodStatus build(){
            V1PodStatus buildable = new V1PodStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setContainerStatuses(fluent.getContainerStatuses());
            buildable.setHostIP(fluent.getHostIP());
            buildable.setInitContainerStatuses(fluent.getInitContainerStatuses());
            buildable.setMessage(fluent.getMessage());
            buildable.setNominatedNodeName(fluent.getNominatedNodeName());
            buildable.setPhase(fluent.getPhase());
            buildable.setPodIP(fluent.getPodIP());
            buildable.setQosClass(fluent.getQosClass());
            buildable.setReason(fluent.getReason());
            buildable.setStartTime(fluent.getStartTime());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodStatusBuilder that = (V1PodStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
