package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodSpecBuilder extends V1PodSpecFluentImpl<V1PodSpecBuilder> implements VisitableBuilder<V1PodSpec,V1PodSpecBuilder>{

    V1PodSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodSpecBuilder(){
            this(true);
    }
    public V1PodSpecBuilder(Boolean validationEnabled){
            this(new V1PodSpec(), validationEnabled);
    }
    public V1PodSpecBuilder(V1PodSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodSpecBuilder(V1PodSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodSpec(), validationEnabled);
    }
    public V1PodSpecBuilder(V1PodSpecFluent<?> fluent,V1PodSpec instance){
            this(fluent, instance, true);
    }
    public V1PodSpecBuilder(V1PodSpecFluent<?> fluent,V1PodSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());

            fluent.withAffinity(instance.getAffinity());

            fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());

            fluent.withContainers(instance.getContainers());

            fluent.withDnsConfig(instance.getDnsConfig());

            fluent.withDnsPolicy(instance.getDnsPolicy());

            fluent.withEnableServiceLinks(instance.getEnableServiceLinks());

            fluent.withHostAliases(instance.getHostAliases());

            fluent.withHostIPC(instance.getHostIPC());

            fluent.withHostNetwork(instance.getHostNetwork());

            fluent.withHostPID(instance.getHostPID());

            fluent.withHostname(instance.getHostname());

            fluent.withImagePullSecrets(instance.getImagePullSecrets());

            fluent.withInitContainers(instance.getInitContainers());

            fluent.withNodeName(instance.getNodeName());

            fluent.withNodeSelector(instance.getNodeSelector());

            fluent.withPreemptionPolicy(instance.getPreemptionPolicy());

            fluent.withPriority(instance.getPriority());

            fluent.withPriorityClassName(instance.getPriorityClassName());

            fluent.withReadinessGates(instance.getReadinessGates());

            fluent.withRestartPolicy(instance.getRestartPolicy());

            fluent.withRuntimeClassName(instance.getRuntimeClassName());

            fluent.withSchedulerName(instance.getSchedulerName());

            fluent.withSecurityContext(instance.getSecurityContext());

            fluent.withServiceAccount(instance.getServiceAccount());

            fluent.withServiceAccountName(instance.getServiceAccountName());

            fluent.withShareProcessNamespace(instance.getShareProcessNamespace());

            fluent.withSubdomain(instance.getSubdomain());

            fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());

            fluent.withTolerations(instance.getTolerations());

            fluent.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodSpecBuilder(V1PodSpec instance){
            this(instance,true);
    }
    public V1PodSpecBuilder(V1PodSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());

            this.withAffinity(instance.getAffinity());

            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());

            this.withContainers(instance.getContainers());

            this.withDnsConfig(instance.getDnsConfig());

            this.withDnsPolicy(instance.getDnsPolicy());

            this.withEnableServiceLinks(instance.getEnableServiceLinks());

            this.withHostAliases(instance.getHostAliases());

            this.withHostIPC(instance.getHostIPC());

            this.withHostNetwork(instance.getHostNetwork());

            this.withHostPID(instance.getHostPID());

            this.withHostname(instance.getHostname());

            this.withImagePullSecrets(instance.getImagePullSecrets());

            this.withInitContainers(instance.getInitContainers());

            this.withNodeName(instance.getNodeName());

            this.withNodeSelector(instance.getNodeSelector());

            this.withPreemptionPolicy(instance.getPreemptionPolicy());

            this.withPriority(instance.getPriority());

            this.withPriorityClassName(instance.getPriorityClassName());

            this.withReadinessGates(instance.getReadinessGates());

            this.withRestartPolicy(instance.getRestartPolicy());

            this.withRuntimeClassName(instance.getRuntimeClassName());

            this.withSchedulerName(instance.getSchedulerName());

            this.withSecurityContext(instance.getSecurityContext());

            this.withServiceAccount(instance.getServiceAccount());

            this.withServiceAccountName(instance.getServiceAccountName());

            this.withShareProcessNamespace(instance.getShareProcessNamespace());

            this.withSubdomain(instance.getSubdomain());

            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());

            this.withTolerations(instance.getTolerations());

            this.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodSpec build(){
            V1PodSpec buildable = new V1PodSpec();
            buildable.setActiveDeadlineSeconds(fluent.getActiveDeadlineSeconds());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setAutomountServiceAccountToken(fluent.isAutomountServiceAccountToken());
            buildable.setContainers(fluent.getContainers());
            buildable.setDnsConfig(fluent.getDnsConfig());
            buildable.setDnsPolicy(fluent.getDnsPolicy());
            buildable.setEnableServiceLinks(fluent.isEnableServiceLinks());
            buildable.setHostAliases(fluent.getHostAliases());
            buildable.setHostIPC(fluent.isHostIPC());
            buildable.setHostNetwork(fluent.isHostNetwork());
            buildable.setHostPID(fluent.isHostPID());
            buildable.setHostname(fluent.getHostname());
            buildable.setImagePullSecrets(fluent.getImagePullSecrets());
            buildable.setInitContainers(fluent.getInitContainers());
            buildable.setNodeName(fluent.getNodeName());
            buildable.setNodeSelector(fluent.getNodeSelector());
            buildable.setPreemptionPolicy(fluent.getPreemptionPolicy());
            buildable.setPriority(fluent.getPriority());
            buildable.setPriorityClassName(fluent.getPriorityClassName());
            buildable.setReadinessGates(fluent.getReadinessGates());
            buildable.setRestartPolicy(fluent.getRestartPolicy());
            buildable.setRuntimeClassName(fluent.getRuntimeClassName());
            buildable.setSchedulerName(fluent.getSchedulerName());
            buildable.setSecurityContext(fluent.getSecurityContext());
            buildable.setServiceAccount(fluent.getServiceAccount());
            buildable.setServiceAccountName(fluent.getServiceAccountName());
            buildable.setShareProcessNamespace(fluent.isShareProcessNamespace());
            buildable.setSubdomain(fluent.getSubdomain());
            buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setVolumes(fluent.getVolumes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodSpecBuilder that = (V1PodSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
