package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NamespaceStatusBuilder extends V1NamespaceStatusFluentImpl<V1NamespaceStatusBuilder> implements VisitableBuilder<V1NamespaceStatus,V1NamespaceStatusBuilder>{

    V1NamespaceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1NamespaceStatusBuilder(){
            this(true);
    }
    public V1NamespaceStatusBuilder(Boolean validationEnabled){
            this(new V1NamespaceStatus(), validationEnabled);
    }
    public V1NamespaceStatusBuilder(V1NamespaceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1NamespaceStatusBuilder(V1NamespaceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NamespaceStatus(), validationEnabled);
    }
    public V1NamespaceStatusBuilder(V1NamespaceStatusFluent<?> fluent,V1NamespaceStatus instance){
            this(fluent, instance, true);
    }
    public V1NamespaceStatusBuilder(V1NamespaceStatusFluent<?> fluent,V1NamespaceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }
    public V1NamespaceStatusBuilder(V1NamespaceStatus instance){
            this(instance,true);
    }
    public V1NamespaceStatusBuilder(V1NamespaceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }

    public V1NamespaceStatus build(){
            V1NamespaceStatus buildable = new V1NamespaceStatus();
            buildable.setPhase(fluent.getPhase());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NamespaceStatusBuilder that = (V1NamespaceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
