package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1ContainerStatusFluent<A extends V1ContainerStatusFluent<A>> extends Fluent<A>{


    public String getContainerID();
    public A withContainerID(String containerID);
    public Boolean hasContainerID();
    public A withNewContainerID(String arg1);
    public A withNewContainerID(StringBuilder arg1);
    public A withNewContainerID(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getImageID();
    public A withImageID(String imageID);
    public Boolean hasImageID();
    public A withNewImageID(String arg1);
    public A withNewImageID(StringBuilder arg1);
    public A withNewImageID(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildLastState instead.
 * @return The buildable object.
 */
@Deprecated public V1ContainerState getLastState();
    public V1ContainerState buildLastState();
    public A withLastState(V1ContainerState lastState);
    public Boolean hasLastState();
    public V1ContainerStatusFluent.LastStateNested<A> withNewLastState();
    public V1ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(V1ContainerState item);
    public V1ContainerStatusFluent.LastStateNested<A> editLastState();
    public V1ContainerStatusFluent.LastStateNested<A> editOrNewLastState();
    public V1ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(V1ContainerState item);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public Boolean isReady();
    public A withReady(Boolean ready);
    public Boolean hasReady();
    public A withNewReady(String arg1);
    public A withNewReady(boolean arg1);
    public Integer getRestartCount();
    public A withRestartCount(Integer restartCount);
    public Boolean hasRestartCount();
    
/**
 * This method has been deprecated, please use method buildState instead.
 * @return The buildable object.
 */
@Deprecated public V1ContainerState getState();
    public V1ContainerState buildState();
    public A withState(V1ContainerState state);
    public Boolean hasState();
    public V1ContainerStatusFluent.StateNested<A> withNewState();
    public V1ContainerStatusFluent.StateNested<A> withNewStateLike(V1ContainerState item);
    public V1ContainerStatusFluent.StateNested<A> editState();
    public V1ContainerStatusFluent.StateNested<A> editOrNewState();
    public V1ContainerStatusFluent.StateNested<A> editOrNewStateLike(V1ContainerState item);

    public interface LastStateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerStateFluent<V1ContainerStatusFluent.LastStateNested<N>>{

        
    public N and();    public N endLastState();
}
    public interface StateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerStateFluent<V1ContainerStatusFluent.StateNested<N>>{

        
    public N and();    public N endState();
}


}
