package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkingV1beta1IngressRuleFluentImpl<A extends NetworkingV1beta1IngressRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements NetworkingV1beta1IngressRuleFluent<A>{

    private String host;
    private NetworkingV1beta1HTTPIngressRuleValueBuilder http;

    public NetworkingV1beta1IngressRuleFluentImpl(){
    }
    public NetworkingV1beta1IngressRuleFluentImpl(NetworkingV1beta1IngressRule instance){
            this.withHost(instance.getHost());

            this.withHttp(instance.getHttp());

    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public NetworkingV1beta1HTTPIngressRuleValue getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public NetworkingV1beta1HTTPIngressRuleValue buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(NetworkingV1beta1HTTPIngressRuleValue http){
            _visitables.get("http").remove(this.http);
            if (http!=null){ this.http= new NetworkingV1beta1HTTPIngressRuleValueBuilder(http); _visitables.get("http").add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public NetworkingV1beta1IngressRuleFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public NetworkingV1beta1IngressRuleFluent.HttpNested<A> withNewHttpLike(NetworkingV1beta1HTTPIngressRuleValue item){
            return new HttpNestedImpl(item);
    }

    public NetworkingV1beta1IngressRuleFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public NetworkingV1beta1IngressRuleFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new NetworkingV1beta1HTTPIngressRuleValueBuilder().build());
    }

    public NetworkingV1beta1IngressRuleFluent.HttpNested<A> editOrNewHttpLike(NetworkingV1beta1HTTPIngressRuleValue item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            NetworkingV1beta1IngressRuleFluentImpl that = (NetworkingV1beta1IngressRuleFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends NetworkingV1beta1HTTPIngressRuleValueFluentImpl<NetworkingV1beta1IngressRuleFluent.HttpNested<N>> implements NetworkingV1beta1IngressRuleFluent.HttpNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final NetworkingV1beta1HTTPIngressRuleValueBuilder builder;
    
            HttpNestedImpl(NetworkingV1beta1HTTPIngressRuleValue item){
                    this.builder = new NetworkingV1beta1HTTPIngressRuleValueBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new NetworkingV1beta1HTTPIngressRuleValueBuilder(this);
            }
    
    public N and(){
            return (N) NetworkingV1beta1IngressRuleFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}


}
