package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ExtensionsV1beta1IngressBackendFluentImpl<A extends ExtensionsV1beta1IngressBackendFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1IngressBackendFluent<A>{

    private String serviceName;
    private IntOrString servicePort;

    public ExtensionsV1beta1IngressBackendFluentImpl(){
    }
    public ExtensionsV1beta1IngressBackendFluentImpl(ExtensionsV1beta1IngressBackend instance){
            this.withServiceName(instance.getServiceName());

            this.withServicePort(instance.getServicePort());

    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName(){
            return this.serviceName != null;
    }

    public A withNewServiceName(String arg1){
            return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuilder arg1){
            return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuffer arg1){
            return (A)withServiceName(new String(arg1));
    }

    public IntOrString getServicePort(){
            return this.servicePort;
    }

    public A withServicePort(IntOrString servicePort){
            this.servicePort=servicePort; return (A) this;
    }

    public Boolean hasServicePort(){
            return this.servicePort != null;
    }

    public A withNewServicePort(final int value){
            return (A)withServicePort(new IntOrString(value));
    }

    public A withNewServicePort(final String value){
            return (A)withServicePort(new IntOrString(value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExtensionsV1beta1IngressBackendFluentImpl that = (ExtensionsV1beta1IngressBackendFluentImpl) o;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
            return true;
    }




}
