package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1DeploymentBuilder extends AppsV1beta1DeploymentFluentImpl<AppsV1beta1DeploymentBuilder> implements VisitableBuilder<AppsV1beta1Deployment,AppsV1beta1DeploymentBuilder>{

    AppsV1beta1DeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1DeploymentBuilder(){
            this(true);
    }
    public AppsV1beta1DeploymentBuilder(Boolean validationEnabled){
            this(new AppsV1beta1Deployment(), validationEnabled);
    }
    public AppsV1beta1DeploymentBuilder(AppsV1beta1DeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1DeploymentBuilder(AppsV1beta1DeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1Deployment(), validationEnabled);
    }
    public AppsV1beta1DeploymentBuilder(AppsV1beta1DeploymentFluent<?> fluent,AppsV1beta1Deployment instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1DeploymentBuilder(AppsV1beta1DeploymentFluent<?> fluent,AppsV1beta1Deployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1DeploymentBuilder(AppsV1beta1Deployment instance){
            this(instance,true);
    }
    public AppsV1beta1DeploymentBuilder(AppsV1beta1Deployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1Deployment build(){
            AppsV1beta1Deployment buildable = new AppsV1beta1Deployment();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentBuilder that = (AppsV1beta1DeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
