/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1beta1ValidatingWebhookConfiguration;
import io.kubernetes.client.models.V1beta1ValidatingWebhookConfigurationFluent;
import io.kubernetes.client.models.V1beta1Webhook;
import io.kubernetes.client.models.V1beta1WebhookBuilder;
import io.kubernetes.client.models.V1beta1WebhookFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1beta1ValidatingWebhookConfigurationFluentImpl<A extends V1beta1ValidatingWebhookConfigurationFluent<A>>
extends BaseFluent<A>
implements V1beta1ValidatingWebhookConfigurationFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1beta1WebhookBuilder> webhooks;

    public V1beta1ValidatingWebhookConfigurationFluentImpl() {
    }

    public V1beta1ValidatingWebhookConfigurationFluentImpl(V1beta1ValidatingWebhookConfiguration instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withWebhooks(instance.getWebhooks());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToWebhooks(int index, V1beta1Webhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1beta1WebhookBuilder>();
        }
        V1beta1WebhookBuilder builder = new V1beta1WebhookBuilder(item);
        this._visitables.get("webhooks").add(index >= 0 ? index : this._visitables.get("webhooks").size(), builder);
        this.webhooks.add(index >= 0 ? index : this.webhooks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWebhooks(int index, V1beta1Webhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1beta1WebhookBuilder>();
        }
        V1beta1WebhookBuilder builder = new V1beta1WebhookBuilder(item);
        if (index < 0 || index >= this._visitables.get("webhooks").size()) {
            this._visitables.get("webhooks").add(builder);
        } else {
            this._visitables.get("webhooks").set(index, builder);
        }
        if (index < 0 || index >= this.webhooks.size()) {
            this.webhooks.add(builder);
        } else {
            this.webhooks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWebhooks(V1beta1Webhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1beta1WebhookBuilder>();
        }
        for (V1beta1Webhook item : items) {
            V1beta1WebhookBuilder builder = new V1beta1WebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWebhooks(Collection<V1beta1Webhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1beta1WebhookBuilder>();
        }
        for (V1beta1Webhook item : items) {
            V1beta1WebhookBuilder builder = new V1beta1WebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWebhooks(V1beta1Webhook ... items) {
        for (V1beta1Webhook item : items) {
            V1beta1WebhookBuilder builder = new V1beta1WebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWebhooks(Collection<V1beta1Webhook> items) {
        for (V1beta1Webhook item : items) {
            V1beta1WebhookBuilder builder = new V1beta1WebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1Webhook> getWebhooks() {
        return V1beta1ValidatingWebhookConfigurationFluentImpl.build(this.webhooks);
    }

    @Override
    public List<V1beta1Webhook> buildWebhooks() {
        return V1beta1ValidatingWebhookConfigurationFluentImpl.build(this.webhooks);
    }

    @Override
    public V1beta1Webhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    @Override
    public V1beta1Webhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    @Override
    public V1beta1Webhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    @Override
    public V1beta1Webhook buildMatchingWebhook(Predicate<V1beta1WebhookBuilder> predicate) {
        for (V1beta1WebhookBuilder item : this.webhooks) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWebhook(Predicate<V1beta1WebhookBuilder> predicate) {
        for (V1beta1WebhookBuilder item : this.webhooks) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWebhooks(List<V1beta1Webhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get("webhooks").removeAll(this.webhooks);
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList<V1beta1WebhookBuilder>();
            for (V1beta1Webhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)this;
    }

    @Override
    public A withWebhooks(V1beta1Webhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
        }
        if (webhooks != null) {
            for (V1beta1Webhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new WebhooksNestedImpl();
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(V1beta1Webhook item) {
        return new WebhooksNestedImpl(-1, item);
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index, V1beta1Webhook item) {
        return new WebhooksNestedImpl(index, item);
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(Predicate<V1beta1WebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.apply(this.webhooks.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1ValidatingWebhookConfigurationFluentImpl that = (V1beta1ValidatingWebhookConfigurationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.webhooks != null ? !this.webhooks.equals(that.webhooks) : that.webhooks != null);
    }

    public class WebhooksNestedImpl<N>
    extends V1beta1WebhookFluentImpl<V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<N>>
    implements V1beta1ValidatingWebhookConfigurationFluent.WebhooksNested<N>,
    Nested<N> {
        private final V1beta1WebhookBuilder builder;
        private final int index;

        WebhooksNestedImpl(int index, V1beta1Webhook item) {
            this.index = index;
            this.builder = new V1beta1WebhookBuilder(this, item);
        }

        WebhooksNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1WebhookBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(this.index, this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<N>>
    implements V1beta1ValidatingWebhookConfigurationFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1ValidatingWebhookConfigurationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

