/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="TCPSocketAction describes an action based on opening a socket")
public class V1TCPSocketAction {
    @SerializedName(value="host")
    private String host = null;
    @SerializedName(value="port")
    private IntOrString port = null;

    public V1TCPSocketAction host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(value="Optional: Host name to connect to, defaults to the pod IP.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public V1TCPSocketAction port(IntOrString port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(IntOrString port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TCPSocketAction v1TCPSocketAction = (V1TCPSocketAction)o;
        return Objects.equals(this.host, v1TCPSocketAction.host) && Objects.equals(this.port, v1TCPSocketAction.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TCPSocketAction {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

