/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1NonResourceAttributes;
import io.kubernetes.client.models.V1NonResourceAttributesBuilder;
import io.kubernetes.client.models.V1NonResourceAttributesFluentImpl;
import io.kubernetes.client.models.V1ResourceAttributes;
import io.kubernetes.client.models.V1ResourceAttributesBuilder;
import io.kubernetes.client.models.V1ResourceAttributesFluentImpl;
import io.kubernetes.client.models.V1SubjectAccessReviewSpec;
import io.kubernetes.client.models.V1SubjectAccessReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class V1SubjectAccessReviewSpecFluentImpl<A extends V1SubjectAccessReviewSpecFluent<A>>
extends BaseFluent<A>
implements V1SubjectAccessReviewSpecFluent<A> {
    private Map<String, List<String>> extra;
    private List<String> groups;
    private V1NonResourceAttributesBuilder nonResourceAttributes;
    private V1ResourceAttributesBuilder resourceAttributes;
    private String uid;
    private String user;

    public V1SubjectAccessReviewSpecFluentImpl() {
    }

    public V1SubjectAccessReviewSpecFluentImpl(V1SubjectAccessReviewSpec instance) {
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withNonResourceAttributes(instance.getNonResourceAttributes());
        this.withResourceAttributes(instance.getResourceAttributes());
        this.withUid(instance.getUid());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToExtra(String key, List<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, List<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, List<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    @Override
    public A withExtra(Map<String, List<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, List<String>>(extra);
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").removeAll(this.groups);
        }
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addNewGroup(String arg1) {
        return this.addToGroups(new String(arg1));
    }

    @Override
    public A addNewGroup(StringBuilder arg1) {
        return this.addToGroups(new String(arg1));
    }

    @Override
    public A addNewGroup(StringBuffer arg1) {
        return this.addToGroups(new String(arg1));
    }

    @Override
    @Deprecated
    public V1NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public V1NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public A withNonResourceAttributes(V1NonResourceAttributes nonResourceAttributes) {
        this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        if (nonResourceAttributes != null) {
            this.nonResourceAttributes = new V1NonResourceAttributesBuilder(nonResourceAttributes);
            this._visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNestedImpl();
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(V1NonResourceAttributes item) {
        return new NonResourceAttributesNestedImpl(item);
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes());
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : new V1NonResourceAttributesBuilder().build());
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(V1NonResourceAttributes item) {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : item);
    }

    @Override
    @Deprecated
    public V1ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public V1ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public A withResourceAttributes(V1ResourceAttributes resourceAttributes) {
        this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
        if (resourceAttributes != null) {
            this.resourceAttributes = new V1ResourceAttributesBuilder(resourceAttributes);
            this._visitables.get("resourceAttributes").add(this.resourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNestedImpl();
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(V1ResourceAttributes item) {
        return new ResourceAttributesNestedImpl(item);
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes());
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : new V1ResourceAttributesBuilder().build());
    }

    @Override
    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(V1ResourceAttributes item) {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : item);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A withNewUid(String arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuilder arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuffer arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A withNewUser(String arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuilder arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuffer arg1) {
        return this.withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SubjectAccessReviewSpecFluentImpl that = (V1SubjectAccessReviewSpecFluentImpl)o;
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.nonResourceAttributes != null ? !this.nonResourceAttributes.equals(that.nonResourceAttributes) : that.nonResourceAttributes != null) {
            return false;
        }
        if (this.resourceAttributes != null ? !this.resourceAttributes.equals(that.resourceAttributes) : that.resourceAttributes != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class ResourceAttributesNestedImpl<N>
    extends V1ResourceAttributesFluentImpl<V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>>
    implements V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,
    Nested<N> {
        private final V1ResourceAttributesBuilder builder;

        ResourceAttributesNestedImpl(V1ResourceAttributes item) {
            this.builder = new V1ResourceAttributesBuilder(this, item);
        }

        ResourceAttributesNestedImpl() {
            this.builder = new V1ResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(this.builder.build());
        }

        @Override
        public N endResourceAttributes() {
            return this.and();
        }
    }

    public class NonResourceAttributesNestedImpl<N>
    extends V1NonResourceAttributesFluentImpl<V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>>
    implements V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,
    Nested<N> {
        private final V1NonResourceAttributesBuilder builder;

        NonResourceAttributesNestedImpl(V1NonResourceAttributes item) {
            this.builder = new V1NonResourceAttributesBuilder(this, item);
        }

        NonResourceAttributesNestedImpl() {
            this.builder = new V1NonResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(this.builder.build());
        }

        @Override
        public N endNonResourceAttributes() {
            return this.and();
        }
    }
}

