/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services.")
public class V1beta1ServiceCIDRSpec {
    public static final String SERIALIZED_NAME_CIDRS = "cidrs";
    @SerializedName(value="cidrs")
    @Nullable
    private List<String> cidrs = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1ServiceCIDRSpec cidrs(@Nullable List<String> cidrs) {
        this.cidrs = cidrs;
        return this;
    }

    public V1beta1ServiceCIDRSpec addCidrsItem(String cidrsItem) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.add(cidrsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CIDRs defines the IP blocks in CIDR notation (e.g. \"192.168.0.0/24\" or \"2001:db8::/64\") from which to assign service cluster IPs. Max of two CIDRs is allowed, one of each IP family. This field is immutable.")
    public List<String> getCidrs() {
        return this.cidrs;
    }

    public void setCidrs(@Nullable List<String> cidrs) {
        this.cidrs = cidrs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1ServiceCIDRSpec v1beta1ServiceCIDRSpec = (V1beta1ServiceCIDRSpec)o;
        return Objects.equals(this.cidrs, v1beta1ServiceCIDRSpec.cidrs);
    }

    public int hashCode() {
        return Objects.hash(this.cidrs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1ServiceCIDRSpec {\n");
        sb.append("    cidrs: ").append(this.toIndentedString(this.cidrs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1ServiceCIDRSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1ServiceCIDRSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CIDRS) != null && !jsonObj.get(SERIALIZED_NAME_CIDRS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CIDRS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cidrs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CIDRS).toString()));
        }
    }

    public static V1beta1ServiceCIDRSpec fromJson(String jsonString) throws IOException {
        return (V1beta1ServiceCIDRSpec)JSON.getGson().fromJson(jsonString, V1beta1ServiceCIDRSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CIDRS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1ServiceCIDRSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1ServiceCIDRSpec.class));
            return new TypeAdapter<V1beta1ServiceCIDRSpec>(){

                public void write(JsonWriter out, V1beta1ServiceCIDRSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1ServiceCIDRSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1ServiceCIDRSpec.validateJsonElement(jsonElement);
                    return (V1beta1ServiceCIDRSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

