/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta1DeviceToleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceRequestAllocationResult contains the allocation result for one request.")
public class V1beta1DeviceRequestAllocationResult {
    public static final String SERIALIZED_NAME_ADMIN_ACCESS = "adminAccess";
    @SerializedName(value="adminAccess")
    @Nullable
    private Boolean adminAccess;
    public static final String SERIALIZED_NAME_BINDING_CONDITIONS = "bindingConditions";
    @SerializedName(value="bindingConditions")
    @Nullable
    private List<String> bindingConditions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS = "bindingFailureConditions";
    @SerializedName(value="bindingFailureConditions")
    @Nullable
    private List<String> bindingFailureConditions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CONSUMED_CAPACITY = "consumedCapacity";
    @SerializedName(value="consumedCapacity")
    @Nullable
    private Map<String, Quantity> consumedCapacity = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    @Nonnull
    private String device;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    @Nonnull
    private String driver;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    @Nonnull
    private String pool;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    @Nonnull
    private String request;
    public static final String SERIALIZED_NAME_SHARE_I_D = "shareID";
    @SerializedName(value="shareID")
    @Nullable
    private String shareID;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    @Nullable
    private List<V1beta1DeviceToleration> tolerations = new ArrayList<V1beta1DeviceToleration>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1DeviceRequestAllocationResult adminAccess(@Nullable Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.  This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.")
    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(@Nullable Boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public V1beta1DeviceRequestAllocationResult bindingConditions(@Nullable List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
        return this;
    }

    public V1beta1DeviceRequestAllocationResult addBindingConditionsItem(String bindingConditionsItem) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.add(bindingConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingConditions contains a copy of the BindingConditions from the corresponding ResourceSlice at the time of allocation.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingConditions() {
        return this.bindingConditions;
    }

    public void setBindingConditions(@Nullable List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
    }

    public V1beta1DeviceRequestAllocationResult bindingFailureConditions(@Nullable List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
        return this;
    }

    public V1beta1DeviceRequestAllocationResult addBindingFailureConditionsItem(String bindingFailureConditionsItem) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.add(bindingFailureConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingFailureConditions contains a copy of the BindingFailureConditions from the corresponding ResourceSlice at the time of allocation.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingFailureConditions() {
        return this.bindingFailureConditions;
    }

    public void setBindingFailureConditions(@Nullable List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
    }

    public V1beta1DeviceRequestAllocationResult consumedCapacity(@Nullable Map<String, Quantity> consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public V1beta1DeviceRequestAllocationResult putConsumedCapacityItem(String key, Quantity consumedCapacityItem) {
        if (this.consumedCapacity == null) {
            this.consumedCapacity = new HashMap<String, Quantity>();
        }
        this.consumedCapacity.put(key, consumedCapacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsumedCapacity tracks the amount of capacity consumed per device as part of the claim request. The consumed amount may differ from the requested amount: it is rounded up to the nearest valid value based on the device\u2019s requestPolicy if applicable (i.e., may not be less than the requested amount).  The total consumed capacity for each device must not exceed the DeviceCapacity's Value.  This field is populated only for devices that allow multiple allocations. All capacity entries are included, even if the consumed amount is zero.")
    public Map<String, Quantity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(@Nullable Map<String, Quantity> consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public V1beta1DeviceRequestAllocationResult device(@Nonnull String device) {
        this.device = device;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Device references one device instance via its name in the driver's resource pool. It must be a DNS label.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(@Nonnull String device) {
        this.device = device;
    }

    public V1beta1DeviceRequestAllocationResult driver(@Nonnull String driver) {
        this.driver = driver;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(@Nonnull String driver) {
        this.driver = driver;
    }

    public V1beta1DeviceRequestAllocationResult pool(@Nonnull String pool) {
        this.pool = pool;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).  Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(@Nonnull String pool) {
        this.pool = pool;
    }

    public V1beta1DeviceRequestAllocationResult request(@Nonnull String request) {
        this.request = request;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.  Multiple devices may have been allocated per request.")
    public String getRequest() {
        return this.request;
    }

    public void setRequest(@Nonnull String request) {
        this.request = request;
    }

    public V1beta1DeviceRequestAllocationResult shareID(@Nullable String shareID) {
        this.shareID = shareID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ShareID uniquely identifies an individual allocation share of the device, used when the device supports multiple simultaneous allocations. It serves as an additional map key to differentiate concurrent shares of the same device.")
    public String getShareID() {
        return this.shareID;
    }

    public void setShareID(@Nullable String shareID) {
        this.shareID = shareID;
    }

    public V1beta1DeviceRequestAllocationResult tolerations(@Nullable List<V1beta1DeviceToleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta1DeviceRequestAllocationResult addTolerationsItem(V1beta1DeviceToleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1beta1DeviceToleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A copy of all tolerations specified in the request at the time when the device got allocated.  The maximum number of tolerations is 16.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta1DeviceToleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(@Nullable List<V1beta1DeviceToleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceRequestAllocationResult v1beta1DeviceRequestAllocationResult = (V1beta1DeviceRequestAllocationResult)o;
        return Objects.equals(this.adminAccess, v1beta1DeviceRequestAllocationResult.adminAccess) && Objects.equals(this.bindingConditions, v1beta1DeviceRequestAllocationResult.bindingConditions) && Objects.equals(this.bindingFailureConditions, v1beta1DeviceRequestAllocationResult.bindingFailureConditions) && Objects.equals(this.consumedCapacity, v1beta1DeviceRequestAllocationResult.consumedCapacity) && Objects.equals(this.device, v1beta1DeviceRequestAllocationResult.device) && Objects.equals(this.driver, v1beta1DeviceRequestAllocationResult.driver) && Objects.equals(this.pool, v1beta1DeviceRequestAllocationResult.pool) && Objects.equals(this.request, v1beta1DeviceRequestAllocationResult.request) && Objects.equals(this.shareID, v1beta1DeviceRequestAllocationResult.shareID) && Objects.equals(this.tolerations, v1beta1DeviceRequestAllocationResult.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.bindingConditions, this.bindingFailureConditions, this.consumedCapacity, this.device, this.driver, this.pool, this.request, this.shareID, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceRequestAllocationResult {\n");
        sb.append("    adminAccess: ").append(this.toIndentedString(this.adminAccess)).append("\n");
        sb.append("    bindingConditions: ").append(this.toIndentedString(this.bindingConditions)).append("\n");
        sb.append("    bindingFailureConditions: ").append(this.toIndentedString(this.bindingFailureConditions)).append("\n");
        sb.append("    consumedCapacity: ").append(this.toIndentedString(this.consumedCapacity)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    shareID: ").append(this.toIndentedString(this.shareID)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraytolerations;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1DeviceRequestAllocationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1DeviceRequestAllocationResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bindingConditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bindingFailureConditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DEVICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `device` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_POOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pool` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REQUEST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `request` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHARE_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SHARE_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHARE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shareID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARE_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOLERATIONS) != null && !jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonNull() && (jsonArraytolerations = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOLERATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tolerations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOLERATIONS).toString()));
            }
            for (int i = 0; i < jsonArraytolerations.size(); ++i) {
                V1beta1DeviceToleration.validateJsonElement(jsonArraytolerations.get(i));
            }
        }
    }

    public static V1beta1DeviceRequestAllocationResult fromJson(String jsonString) throws IOException {
        return (V1beta1DeviceRequestAllocationResult)JSON.getGson().fromJson(jsonString, V1beta1DeviceRequestAllocationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADMIN_ACCESS);
        openapiFields.add(SERIALIZED_NAME_BINDING_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CONSUMED_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_DEVICE);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_POOL);
        openapiFields.add(SERIALIZED_NAME_REQUEST);
        openapiFields.add(SERIALIZED_NAME_SHARE_I_D);
        openapiFields.add(SERIALIZED_NAME_TOLERATIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICE);
        openapiRequiredFields.add(SERIALIZED_NAME_DRIVER);
        openapiRequiredFields.add(SERIALIZED_NAME_POOL);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUEST);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1DeviceRequestAllocationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1DeviceRequestAllocationResult.class));
            return new TypeAdapter<V1beta1DeviceRequestAllocationResult>(){

                public void write(JsonWriter out, V1beta1DeviceRequestAllocationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1DeviceRequestAllocationResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1DeviceRequestAllocationResult.validateJsonElement(jsonElement);
                    return (V1beta1DeviceRequestAllocationResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

