/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.")
public class V1alpha3DeviceTaintSelector {
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    @Nullable
    private String device;
    public static final String SERIALIZED_NAME_DEVICE_CLASS_NAME = "deviceClassName";
    @SerializedName(value="deviceClassName")
    @Nullable
    private String deviceClassName;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    @Nullable
    private String driver;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    @Nullable
    private String pool;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    @Nullable
    private List<V1alpha3DeviceSelector> selectors = new ArrayList<V1alpha3DeviceSelector>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3DeviceTaintSelector device(@Nullable String device) {
        this.device = device;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.  Setting also driver and pool may be required to avoid ambiguity, but is not required.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(@Nullable String device) {
        this.device = device;
    }

    public V1alpha3DeviceTaintSelector deviceClassName(@Nullable String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If DeviceClassName is set, the selectors defined there must be satisfied by a device to be selected. This field corresponds to class.metadata.name.")
    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public void setDeviceClassName(@Nullable String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }

    public V1alpha3DeviceTaintSelector driver(@Nullable String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(@Nullable String driver) {
        this.driver = driver;
    }

    public V1alpha3DeviceTaintSelector pool(@Nullable String pool) {
        this.pool = pool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If pool is set, only devices in that pool are selected.  Also setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(@Nullable String pool) {
        this.pool = pool;
    }

    public V1alpha3DeviceTaintSelector selectors(@Nullable List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1alpha3DeviceTaintSelector addSelectorsItem(V1alpha3DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1alpha3DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selectors contains the same selection criteria as a ResourceClaim. Currently, CEL expressions are supported. All of these selectors must be satisfied.")
    public List<V1alpha3DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(@Nullable List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3DeviceTaintSelector v1alpha3DeviceTaintSelector = (V1alpha3DeviceTaintSelector)o;
        return Objects.equals(this.device, v1alpha3DeviceTaintSelector.device) && Objects.equals(this.deviceClassName, v1alpha3DeviceTaintSelector.deviceClassName) && Objects.equals(this.driver, v1alpha3DeviceTaintSelector.driver) && Objects.equals(this.pool, v1alpha3DeviceTaintSelector.pool) && Objects.equals(this.selectors, v1alpha3DeviceTaintSelector.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.device, this.deviceClassName, this.driver, this.pool, this.selectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3DeviceTaintSelector {\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    deviceClassName: ").append(this.toIndentedString(this.deviceClassName)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayselectors;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3DeviceTaintSelector is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3DeviceTaintSelector` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DEVICE) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEVICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `device` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEVICE_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deviceClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POOL) != null && !jsonObj.get(SERIALIZED_NAME_POOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pool` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTORS) != null && !jsonObj.get(SERIALIZED_NAME_SELECTORS).isJsonNull() && (jsonArrayselectors = jsonObj.getAsJsonArray(SERIALIZED_NAME_SELECTORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SELECTORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `selectors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTORS).toString()));
            }
            for (int i = 0; i < jsonArrayselectors.size(); ++i) {
                V1alpha3DeviceSelector.validateJsonElement(jsonArrayselectors.get(i));
            }
        }
    }

    public static V1alpha3DeviceTaintSelector fromJson(String jsonString) throws IOException {
        return (V1alpha3DeviceTaintSelector)JSON.getGson().fromJson(jsonString, V1alpha3DeviceTaintSelector.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DEVICE);
        openapiFields.add(SERIALIZED_NAME_DEVICE_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_POOL);
        openapiFields.add(SERIALIZED_NAME_SELECTORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3DeviceTaintSelector.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3DeviceTaintSelector.class));
            return new TypeAdapter<V1alpha3DeviceTaintSelector>(){

                public void write(JsonWriter out, V1alpha3DeviceTaintSelector value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3DeviceTaintSelector read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3DeviceTaintSelector.validateJsonElement(jsonElement);
                    return (V1alpha3DeviceTaintSelector)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

