/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1Condition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodCertificateRequestStatus describes the status of the request, and holds the certificate data if the request is issued.")
public class V1alpha1PodCertificateRequestStatus {
    public static final String SERIALIZED_NAME_BEGIN_REFRESH_AT = "beginRefreshAt";
    @SerializedName(value="beginRefreshAt")
    @Nullable
    private OffsetDateTime beginRefreshAt;
    public static final String SERIALIZED_NAME_CERTIFICATE_CHAIN = "certificateChain";
    @SerializedName(value="certificateChain")
    @Nullable
    private String certificateChain;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1Condition> conditions = new ArrayList<V1Condition>();
    public static final String SERIALIZED_NAME_NOT_AFTER = "notAfter";
    @SerializedName(value="notAfter")
    @Nullable
    private OffsetDateTime notAfter;
    public static final String SERIALIZED_NAME_NOT_BEFORE = "notBefore";
    @SerializedName(value="notBefore")
    @Nullable
    private OffsetDateTime notBefore;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha1PodCertificateRequestStatus beginRefreshAt(@Nullable OffsetDateTime beginRefreshAt) {
        this.beginRefreshAt = beginRefreshAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="beginRefreshAt is the time at which the kubelet should begin trying to refresh the certificate.  This field is set via the /status subresource, and must be set at the same time as certificateChain.  Once populated, this field is immutable.  This field is only a hint.  Kubelet may start refreshing before or after this time if necessary.")
    public OffsetDateTime getBeginRefreshAt() {
        return this.beginRefreshAt;
    }

    public void setBeginRefreshAt(@Nullable OffsetDateTime beginRefreshAt) {
        this.beginRefreshAt = beginRefreshAt;
    }

    public V1alpha1PodCertificateRequestStatus certificateChain(@Nullable String certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="certificateChain is populated with an issued certificate by the signer. This field is set via the /status subresource. Once populated, this field is immutable.  If the certificate signing request is denied, a condition of type \"Denied\" is added and this field remains empty. If the signer cannot issue the certificate, a condition of type \"Failed\" is added and this field remains empty.  Validation requirements:  1. certificateChain must consist of one or more PEM-formatted certificates.  2. Each entry must be a valid PEM-wrapped, DER-encoded ASN.1 Certificate as     described in section 4 of RFC5280.  If more than one block is present, and the definition of the requested spec.signerName does not indicate otherwise, the first block is the issued certificate, and subsequent blocks should be treated as intermediate certificates and presented in TLS handshakes.  When projecting the chain into a pod volume, kubelet will drop any data in-between the PEM blocks, as well as any PEM block headers.")
    public String getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(@Nullable String certificateChain) {
        this.certificateChain = certificateChain;
    }

    public V1alpha1PodCertificateRequestStatus conditions(@Nullable List<V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1alpha1PodCertificateRequestStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="conditions applied to the request.  The types \"Issued\", \"Denied\", and \"Failed\" have special handling.  At most one of these conditions may be present, and they must have status \"True\".  If the request is denied with `Reason=UnsupportedKeyType`, the signer may suggest a key type that will work in the message field.")
    public List<V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1alpha1PodCertificateRequestStatus notAfter(@Nullable OffsetDateTime notAfter) {
        this.notAfter = notAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="notAfter is the time at which the certificate expires.  The value must be the same as the notAfter value in the leaf certificate in certificateChain.  This field is set via the /status subresource.  Once populated, it is immutable.  The signer must set this field at the same time it sets certificateChain.")
    public OffsetDateTime getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(@Nullable OffsetDateTime notAfter) {
        this.notAfter = notAfter;
    }

    public V1alpha1PodCertificateRequestStatus notBefore(@Nullable OffsetDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="notBefore is the time at which the certificate becomes valid.  The value must be the same as the notBefore value in the leaf certificate in certificateChain.  This field is set via the /status subresource.  Once populated, it is immutable. The signer must set this field at the same time it sets certificateChain.")
    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(@Nullable OffsetDateTime notBefore) {
        this.notBefore = notBefore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PodCertificateRequestStatus v1alpha1PodCertificateRequestStatus = (V1alpha1PodCertificateRequestStatus)o;
        return Objects.equals(this.beginRefreshAt, v1alpha1PodCertificateRequestStatus.beginRefreshAt) && Objects.equals(this.certificateChain, v1alpha1PodCertificateRequestStatus.certificateChain) && Objects.equals(this.conditions, v1alpha1PodCertificateRequestStatus.conditions) && Objects.equals(this.notAfter, v1alpha1PodCertificateRequestStatus.notAfter) && Objects.equals(this.notBefore, v1alpha1PodCertificateRequestStatus.notBefore);
    }

    public int hashCode() {
        return Objects.hash(this.beginRefreshAt, this.certificateChain, this.conditions, this.notAfter, this.notBefore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1PodCertificateRequestStatus {\n");
        sb.append("    beginRefreshAt: ").append(this.toIndentedString(this.beginRefreshAt)).append("\n");
        sb.append("    certificateChain: ").append(this.toIndentedString(this.certificateChain)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    notAfter: ").append(this.toIndentedString(this.notAfter)).append("\n");
        sb.append("    notBefore: ").append(this.toIndentedString(this.notBefore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha1PodCertificateRequestStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha1PodCertificateRequestStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN) != null && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `certificateChain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1Condition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
    }

    public static V1alpha1PodCertificateRequestStatus fromJson(String jsonString) throws IOException {
        return (V1alpha1PodCertificateRequestStatus)JSON.getGson().fromJson(jsonString, V1alpha1PodCertificateRequestStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BEGIN_REFRESH_AT);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_CHAIN);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_NOT_AFTER);
        openapiFields.add(SERIALIZED_NAME_NOT_BEFORE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha1PodCertificateRequestStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha1PodCertificateRequestStatus.class));
            return new TypeAdapter<V1alpha1PodCertificateRequestStatus>(){

                public void write(JsonWriter out, V1alpha1PodCertificateRequestStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha1PodCertificateRequestStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha1PodCertificateRequestStatus.validateJsonElement(jsonElement);
                    return (V1alpha1PodCertificateRequestStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

