/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="WindowsSecurityContextOptions contain Windows-specific options and credentials.")
public class V1WindowsSecurityContextOptions {
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC = "gmsaCredentialSpec";
    @SerializedName(value="gmsaCredentialSpec")
    @Nullable
    private String gmsaCredentialSpec;
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME = "gmsaCredentialSpecName";
    @SerializedName(value="gmsaCredentialSpecName")
    @Nullable
    private String gmsaCredentialSpecName;
    public static final String SERIALIZED_NAME_HOST_PROCESS = "hostProcess";
    @SerializedName(value="hostProcess")
    @Nullable
    private Boolean hostProcess;
    public static final String SERIALIZED_NAME_RUN_AS_USER_NAME = "runAsUserName";
    @SerializedName(value="runAsUserName")
    @Nullable
    private String runAsUserName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1WindowsSecurityContextOptions gmsaCredentialSpec(@Nullable String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.")
    public String getGmsaCredentialSpec() {
        return this.gmsaCredentialSpec;
    }

    public void setGmsaCredentialSpec(@Nullable String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
    }

    public V1WindowsSecurityContextOptions gmsaCredentialSpecName(@Nullable String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpecName is the name of the GMSA credential spec to use.")
    public String getGmsaCredentialSpecName() {
        return this.gmsaCredentialSpecName;
    }

    public void setGmsaCredentialSpecName(@Nullable String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
    }

    public V1WindowsSecurityContextOptions hostProcess(@Nullable Boolean hostProcess) {
        this.hostProcess = hostProcess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.")
    public Boolean getHostProcess() {
        return this.hostProcess;
    }

    public void setHostProcess(@Nullable Boolean hostProcess) {
        this.hostProcess = hostProcess;
    }

    public V1WindowsSecurityContextOptions runAsUserName(@Nullable String runAsUserName) {
        this.runAsUserName = runAsUserName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public String getRunAsUserName() {
        return this.runAsUserName;
    }

    public void setRunAsUserName(@Nullable String runAsUserName) {
        this.runAsUserName = runAsUserName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1WindowsSecurityContextOptions v1WindowsSecurityContextOptions = (V1WindowsSecurityContextOptions)o;
        return Objects.equals(this.gmsaCredentialSpec, v1WindowsSecurityContextOptions.gmsaCredentialSpec) && Objects.equals(this.gmsaCredentialSpecName, v1WindowsSecurityContextOptions.gmsaCredentialSpecName) && Objects.equals(this.hostProcess, v1WindowsSecurityContextOptions.hostProcess) && Objects.equals(this.runAsUserName, v1WindowsSecurityContextOptions.runAsUserName);
    }

    public int hashCode() {
        return Objects.hash(this.gmsaCredentialSpec, this.gmsaCredentialSpecName, this.hostProcess, this.runAsUserName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1WindowsSecurityContextOptions {\n");
        sb.append("    gmsaCredentialSpec: ").append(this.toIndentedString(this.gmsaCredentialSpec)).append("\n");
        sb.append("    gmsaCredentialSpecName: ").append(this.toIndentedString(this.gmsaCredentialSpecName)).append("\n");
        sb.append("    hostProcess: ").append(this.toIndentedString(this.hostProcess)).append("\n");
        sb.append("    runAsUserName: ").append(this.toIndentedString(this.runAsUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1WindowsSecurityContextOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1WindowsSecurityContextOptions` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC) != null && !jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gmsaCredentialSpec` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME) != null && !jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gmsaCredentialSpecName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RUN_AS_USER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RUN_AS_USER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RUN_AS_USER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `runAsUserName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RUN_AS_USER_NAME).toString()));
        }
    }

    public static V1WindowsSecurityContextOptions fromJson(String jsonString) throws IOException {
        return (V1WindowsSecurityContextOptions)JSON.getGson().fromJson(jsonString, V1WindowsSecurityContextOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC);
        openapiFields.add(SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME);
        openapiFields.add(SERIALIZED_NAME_HOST_PROCESS);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_USER_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1WindowsSecurityContextOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1WindowsSecurityContextOptions.class));
            return new TypeAdapter<V1WindowsSecurityContextOptions>(){

                public void write(JsonWriter out, V1WindowsSecurityContextOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1WindowsSecurityContextOptions read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1WindowsSecurityContextOptions.validateJsonElement(jsonElement);
                    return (V1WindowsSecurityContextOptions)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

