/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="VolumeResourceRequirements describes the storage resource requirements for a volume.")
public class V1VolumeResourceRequirements {
    public static final String SERIALIZED_NAME_LIMITS = "limits";
    @SerializedName(value="limits")
    @Nullable
    private Map<String, Quantity> limits = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    @Nullable
    private Map<String, Quantity> requests = new HashMap<String, Quantity>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1VolumeResourceRequirements limits(@Nullable Map<String, Quantity> limits) {
        this.limits = limits;
        return this;
    }

    public V1VolumeResourceRequirements putLimitsItem(String key, Quantity limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Quantity>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/")
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public void setLimits(@Nullable Map<String, Quantity> limits) {
        this.limits = limits;
    }

    public V1VolumeResourceRequirements requests(@Nullable Map<String, Quantity> requests) {
        this.requests = requests;
        return this;
    }

    public V1VolumeResourceRequirements putRequestsItem(String key, Quantity requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, Quantity>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/")
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public void setRequests(@Nullable Map<String, Quantity> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeResourceRequirements v1VolumeResourceRequirements = (V1VolumeResourceRequirements)o;
        return Objects.equals(this.limits, v1VolumeResourceRequirements.limits) && Objects.equals(this.requests, v1VolumeResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.limits, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeResourceRequirements {\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1VolumeResourceRequirements is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1VolumeResourceRequirements` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static V1VolumeResourceRequirements fromJson(String jsonString) throws IOException {
        return (V1VolumeResourceRequirements)JSON.getGson().fromJson(jsonString, V1VolumeResourceRequirements.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LIMITS);
        openapiFields.add(SERIALIZED_NAME_REQUESTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1VolumeResourceRequirements.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1VolumeResourceRequirements.class));
            return new TypeAdapter<V1VolumeResourceRequirements>(){

                public void write(JsonWriter out, V1VolumeResourceRequirements value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1VolumeResourceRequirements read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1VolumeResourceRequirements.validateJsonElement(jsonElement);
                    return (V1VolumeResourceRequirements)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

