/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1StatefulSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="StatefulSetStatus represents the current state of a StatefulSet.")
public class V1StatefulSetStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    @Nullable
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_COLLISION_COUNT = "collisionCount";
    @SerializedName(value="collisionCount")
    @Nullable
    private Integer collisionCount;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1StatefulSetCondition> conditions = new ArrayList<V1StatefulSetCondition>();
    public static final String SERIALIZED_NAME_CURRENT_REPLICAS = "currentReplicas";
    @SerializedName(value="currentReplicas")
    @Nullable
    private Integer currentReplicas;
    public static final String SERIALIZED_NAME_CURRENT_REVISION = "currentRevision";
    @SerializedName(value="currentRevision")
    @Nullable
    private String currentRevision;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    @Nullable
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    @Nullable
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    @Nonnull
    private Integer replicas;
    public static final String SERIALIZED_NAME_UPDATE_REVISION = "updateRevision";
    @SerializedName(value="updateRevision")
    @Nullable
    private String updateRevision;
    public static final String SERIALIZED_NAME_UPDATED_REPLICAS = "updatedReplicas";
    @SerializedName(value="updatedReplicas")
    @Nullable
    private Integer updatedReplicas;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1StatefulSetStatus availableReplicas(@Nullable Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(@Nullable Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1StatefulSetStatus collisionCount(@Nullable Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(@Nullable Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1StatefulSetStatus conditions(@Nullable List<V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1StatefulSetStatus addConditionsItem(V1StatefulSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a statefulset's current state.")
    public List<V1StatefulSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1StatefulSetStatus currentReplicas(@Nullable Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.")
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(@Nullable Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1StatefulSetStatus currentRevision(@Nullable String currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).")
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(@Nullable String currentRevision) {
        this.currentRevision = currentRevision;
    }

    public V1StatefulSetStatus observedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1StatefulSetStatus readyReplicas(@Nullable Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(@Nullable Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1StatefulSetStatus replicas(@Nonnull Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="replicas is the number of Pods created by the StatefulSet controller.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(@Nonnull Integer replicas) {
        this.replicas = replicas;
    }

    public V1StatefulSetStatus updateRevision(@Nullable String updateRevision) {
        this.updateRevision = updateRevision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)")
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    public void setUpdateRevision(@Nullable String updateRevision) {
        this.updateRevision = updateRevision;
    }

    public V1StatefulSetStatus updatedReplicas(@Nullable Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(@Nullable Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetStatus v1StatefulSetStatus = (V1StatefulSetStatus)o;
        return Objects.equals(this.availableReplicas, v1StatefulSetStatus.availableReplicas) && Objects.equals(this.collisionCount, v1StatefulSetStatus.collisionCount) && Objects.equals(this.conditions, v1StatefulSetStatus.conditions) && Objects.equals(this.currentReplicas, v1StatefulSetStatus.currentReplicas) && Objects.equals(this.currentRevision, v1StatefulSetStatus.currentRevision) && Objects.equals(this.observedGeneration, v1StatefulSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1StatefulSetStatus.readyReplicas) && Objects.equals(this.replicas, v1StatefulSetStatus.replicas) && Objects.equals(this.updateRevision, v1StatefulSetStatus.updateRevision) && Objects.equals(this.updatedReplicas, v1StatefulSetStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.replicas, this.updateRevision, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    currentRevision: ").append(this.toIndentedString(this.currentRevision)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    updateRevision: ").append(this.toIndentedString(this.updateRevision)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1StatefulSetStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1StatefulSetStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1StatefulSetCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION) != null && !jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currentRevision` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION) != null && !jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updateRevision` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION).toString()));
        }
    }

    public static V1StatefulSetStatus fromJson(String jsonString) throws IOException {
        return (V1StatefulSetStatus)JSON.getGson().fromJson(jsonString, V1StatefulSetStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_COLLISION_COUNT);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REVISION);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiFields.add(SERIALIZED_NAME_READY_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_UPDATE_REVISION);
        openapiFields.add(SERIALIZED_NAME_UPDATED_REPLICAS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REPLICAS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1StatefulSetStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1StatefulSetStatus.class));
            return new TypeAdapter<V1StatefulSetStatus>(){

                public void write(JsonWriter out, V1StatefulSetStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1StatefulSetStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1StatefulSetStatus.validateJsonElement(jsonElement);
                    return (V1StatefulSetStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

