/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ReplicaSetSpec is the specification of a ReplicaSet.")
public class V1ReplicaSetSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    @Nullable
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    @Nullable
    private Integer replicas;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    @Nonnull
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    @Nullable
    private V1PodTemplateSpec template;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ReplicaSetSpec minReadySeconds(@Nullable Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(@Nullable Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1ReplicaSetSpec replicas(@Nullable Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(@Nullable Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicaSetSpec selector(@Nonnull V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(@Nonnull V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1ReplicaSetSpec template(@Nullable V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(@Nullable V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicaSetSpec v1ReplicaSetSpec = (V1ReplicaSetSpec)o;
        return Objects.equals(this.minReadySeconds, v1ReplicaSetSpec.minReadySeconds) && Objects.equals(this.replicas, v1ReplicaSetSpec.replicas) && Objects.equals(this.selector, v1ReplicaSetSpec.selector) && Objects.equals(this.template, v1ReplicaSetSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicaSetSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ReplicaSetSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ReplicaSetSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SELECTOR));
        if (jsonObj.get(SERIALIZED_NAME_TEMPLATE) != null && !jsonObj.get(SERIALIZED_NAME_TEMPLATE).isJsonNull()) {
            V1PodTemplateSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TEMPLATE));
        }
    }

    public static V1ReplicaSetSpec fromJson(String jsonString) throws IOException {
        return (V1ReplicaSetSpec)JSON.getGson().fromJson(jsonString, V1ReplicaSetSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MIN_READY_SECONDS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SELECTOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ReplicaSetSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ReplicaSetSpec.class));
            return new TypeAdapter<V1ReplicaSetSpec>(){

                public void write(JsonWriter out, V1ReplicaSetSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ReplicaSetSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ReplicaSetSpec.validateJsonElement(jsonElement);
                    return (V1ReplicaSetSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

