/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LimitResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:   - How are requests for this priority level limited?   - What should be done with requests that exceed the limit?")
public class V1LimitedPriorityLevelConfiguration {
    public static final String SERIALIZED_NAME_BORROWING_LIMIT_PERCENT = "borrowingLimitPercent";
    @SerializedName(value="borrowingLimitPercent")
    @Nullable
    private Integer borrowingLimitPercent;
    public static final String SERIALIZED_NAME_LENDABLE_PERCENT = "lendablePercent";
    @SerializedName(value="lendablePercent")
    @Nullable
    private Integer lendablePercent;
    public static final String SERIALIZED_NAME_LIMIT_RESPONSE = "limitResponse";
    @SerializedName(value="limitResponse")
    @Nullable
    private V1LimitResponse limitResponse;
    public static final String SERIALIZED_NAME_NOMINAL_CONCURRENCY_SHARES = "nominalConcurrencyShares";
    @SerializedName(value="nominalConcurrencyShares")
    @Nullable
    private Integer nominalConcurrencyShares;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LimitedPriorityLevelConfiguration borrowingLimitPercent(@Nullable Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.  BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )  The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.")
    public Integer getBorrowingLimitPercent() {
        return this.borrowingLimitPercent;
    }

    public void setBorrowingLimitPercent(@Nullable Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
    }

    public V1LimitedPriorityLevelConfiguration lendablePercent(@Nullable Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.  LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )")
    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    public void setLendablePercent(@Nullable Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
    }

    public V1LimitedPriorityLevelConfiguration limitResponse(@Nullable V1LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LimitResponse getLimitResponse() {
        return this.limitResponse;
    }

    public void setLimitResponse(@Nullable V1LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
    }

    public V1LimitedPriorityLevelConfiguration nominalConcurrencyShares(@Nullable Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:  NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)  Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.  If not specified, this field defaults to a value of 30.  Setting this field to zero supports the construction of a \"jail\" for this priority level that is used to hold some request(s)")
    public Integer getNominalConcurrencyShares() {
        return this.nominalConcurrencyShares;
    }

    public void setNominalConcurrencyShares(@Nullable Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LimitedPriorityLevelConfiguration v1LimitedPriorityLevelConfiguration = (V1LimitedPriorityLevelConfiguration)o;
        return Objects.equals(this.borrowingLimitPercent, v1LimitedPriorityLevelConfiguration.borrowingLimitPercent) && Objects.equals(this.lendablePercent, v1LimitedPriorityLevelConfiguration.lendablePercent) && Objects.equals(this.limitResponse, v1LimitedPriorityLevelConfiguration.limitResponse) && Objects.equals(this.nominalConcurrencyShares, v1LimitedPriorityLevelConfiguration.nominalConcurrencyShares);
    }

    public int hashCode() {
        return Objects.hash(this.borrowingLimitPercent, this.lendablePercent, this.limitResponse, this.nominalConcurrencyShares);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LimitedPriorityLevelConfiguration {\n");
        sb.append("    borrowingLimitPercent: ").append(this.toIndentedString(this.borrowingLimitPercent)).append("\n");
        sb.append("    lendablePercent: ").append(this.toIndentedString(this.lendablePercent)).append("\n");
        sb.append("    limitResponse: ").append(this.toIndentedString(this.limitResponse)).append("\n");
        sb.append("    nominalConcurrencyShares: ").append(this.toIndentedString(this.nominalConcurrencyShares)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LimitedPriorityLevelConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LimitedPriorityLevelConfiguration` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_LIMIT_RESPONSE) != null && !jsonObj.get(SERIALIZED_NAME_LIMIT_RESPONSE).isJsonNull()) {
            V1LimitResponse.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIMIT_RESPONSE));
        }
    }

    public static V1LimitedPriorityLevelConfiguration fromJson(String jsonString) throws IOException {
        return (V1LimitedPriorityLevelConfiguration)JSON.getGson().fromJson(jsonString, V1LimitedPriorityLevelConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BORROWING_LIMIT_PERCENT);
        openapiFields.add(SERIALIZED_NAME_LENDABLE_PERCENT);
        openapiFields.add(SERIALIZED_NAME_LIMIT_RESPONSE);
        openapiFields.add(SERIALIZED_NAME_NOMINAL_CONCURRENCY_SHARES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LimitedPriorityLevelConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LimitedPriorityLevelConfiguration.class));
            return new TypeAdapter<V1LimitedPriorityLevelConfiguration>(){

                public void write(JsonWriter out, V1LimitedPriorityLevelConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LimitedPriorityLevelConfiguration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LimitedPriorityLevelConfiguration.validateJsonElement(jsonElement);
                    return (V1LimitedPriorityLevelConfiguration)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

