/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="FileKeySelector selects a key of the env file.")
public class V1FileKeySelector {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    @Nullable
    private Boolean optional;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    @Nonnull
    private String path;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    @Nonnull
    private String volumeName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1FileKeySelector key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The key within the env file. An invalid key will prevent the pod from starting. The keys defined within a source may consist of any printable ASCII characters except '='. During Alpha stage of the EnvFiles feature gate, the key size is limited to 128 characters.")
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public V1FileKeySelector optional(@Nullable Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the file or its key must be defined. If the file or key does not exist, then the env var is not published. If optional is set to true and the specified key does not exist, the environment variable will not be set in the Pod's containers.  If optional is set to false and the specified key does not exist, an error will be returned during Pod creation.")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(@Nullable Boolean optional) {
        this.optional = optional;
    }

    public V1FileKeySelector path(@Nonnull String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The path within the volume from which to select the file. Must be relative and may not contain the '..' path or start with '..'.")
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nonnull String path) {
        this.path = path;
    }

    public V1FileKeySelector volumeName(@Nonnull String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the volume mount containing the env file.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(@Nonnull String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FileKeySelector v1FileKeySelector = (V1FileKeySelector)o;
        return Objects.equals(this.key, v1FileKeySelector.key) && Objects.equals(this.optional, v1FileKeySelector.optional) && Objects.equals(this.path, v1FileKeySelector.path) && Objects.equals(this.volumeName, v1FileKeySelector.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.optional, this.path, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FileKeySelector {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1FileKeySelector is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1FileKeySelector` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).toString()));
        }
    }

    public static V1FileKeySelector fromJson(String jsonString) throws IOException {
        return (V1FileKeySelector)JSON.getGson().fromJson(jsonString, V1FileKeySelector.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_OPTIONAL);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_VOLUME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_PATH);
        openapiRequiredFields.add(SERIALIZED_NAME_VOLUME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1FileKeySelector.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1FileKeySelector.class));
            return new TypeAdapter<V1FileKeySelector>(){

                public void write(JsonWriter out, V1FileKeySelector value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1FileKeySelector read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1FileKeySelector.validateJsonElement(jsonElement);
                    return (V1FileKeySelector)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

