/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="FieldSelectorRequirement is a selector that contains values, a key, and an operator that relates the key and values.")
public class V1FieldSelectorRequirement {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    @Nonnull
    private String operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    @Nullable
    private List<String> values = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1FieldSelectorRequirement key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="key is the field selector key that the requirement applies to.")
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public V1FieldSelectorRequirement operator(@Nonnull String operator) {
        this.operator = operator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. The list of operators may grow in the future.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(@Nonnull String operator) {
        this.operator = operator;
    }

    public V1FieldSelectorRequirement values(@Nullable List<String> values) {
        this.values = values;
        return this;
    }

    public V1FieldSelectorRequirement addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty.")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FieldSelectorRequirement v1FieldSelectorRequirement = (V1FieldSelectorRequirement)o;
        return Objects.equals(this.key, v1FieldSelectorRequirement.key) && Objects.equals(this.operator, v1FieldSelectorRequirement.operator) && Objects.equals(this.values, v1FieldSelectorRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FieldSelectorRequirement {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1FieldSelectorRequirement is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1FieldSelectorRequirement` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUES) != null && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `values` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUES).toString()));
        }
    }

    public static V1FieldSelectorRequirement fromJson(String jsonString) throws IOException {
        return (V1FieldSelectorRequirement)JSON.getGson().fromJson(jsonString, V1FieldSelectorRequirement.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_OPERATOR);
        openapiFields.add(SERIALIZED_NAME_VALUES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_OPERATOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1FieldSelectorRequirement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1FieldSelectorRequirement.class));
            return new TypeAdapter<V1FieldSelectorRequirement>(){

                public void write(JsonWriter out, V1FieldSelectorRequirement value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1FieldSelectorRequirement read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1FieldSelectorRequirement.validateJsonElement(jsonElement);
                    return (V1FieldSelectorRequirement)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

