/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CustomResourceColumnDefinition specifies a column for server side printing.")
public class V1CustomResourceColumnDefinition {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    @Nullable
    private String format;
    public static final String SERIALIZED_NAME_JSON_PATH = "jsonPath";
    @SerializedName(value="jsonPath")
    @Nonnull
    private String jsonPath;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    @Nullable
    private Integer priority;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CustomResourceColumnDefinition description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description is a human readable description of this column.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public V1CustomResourceColumnDefinition format(@Nullable String format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(@Nullable String format) {
        this.format = format;
    }

    public V1CustomResourceColumnDefinition jsonPath(@Nonnull String jsonPath) {
        this.jsonPath = jsonPath;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.")
    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(@Nonnull String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public V1CustomResourceColumnDefinition name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name is a human readable name for the column.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1CustomResourceColumnDefinition priority(@Nullable Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable Integer priority) {
        this.priority = priority;
    }

    public V1CustomResourceColumnDefinition type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.")
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceColumnDefinition v1CustomResourceColumnDefinition = (V1CustomResourceColumnDefinition)o;
        return Objects.equals(this.description, v1CustomResourceColumnDefinition.description) && Objects.equals(this.format, v1CustomResourceColumnDefinition.format) && Objects.equals(this.jsonPath, v1CustomResourceColumnDefinition.jsonPath) && Objects.equals(this.name, v1CustomResourceColumnDefinition.name) && Objects.equals(this.priority, v1CustomResourceColumnDefinition.priority) && Objects.equals(this.type, v1CustomResourceColumnDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.format, this.jsonPath, this.name, this.priority, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceColumnDefinition {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    jsonPath: ").append(this.toIndentedString(this.jsonPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CustomResourceColumnDefinition is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CustomResourceColumnDefinition` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMAT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_JSON_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `jsonPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JSON_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static V1CustomResourceColumnDefinition fromJson(String jsonString) throws IOException {
        return (V1CustomResourceColumnDefinition)JSON.getGson().fromJson(jsonString, V1CustomResourceColumnDefinition.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_FORMAT);
        openapiFields.add(SERIALIZED_NAME_JSON_PATH);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_JSON_PATH);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CustomResourceColumnDefinition.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CustomResourceColumnDefinition.class));
            return new TypeAdapter<V1CustomResourceColumnDefinition>(){

                public void write(JsonWriter out, V1CustomResourceColumnDefinition value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CustomResourceColumnDefinition read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CustomResourceColumnDefinition.validateJsonElement(jsonElement);
                    return (V1CustomResourceColumnDefinition)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

