/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="EndpointPort represents a Port used by an EndpointSlice")
public class DiscoveryV1EndpointPort {
    public static final String SERIALIZED_NAME_APP_PROTOCOL = "appProtocol";
    @SerializedName(value="appProtocol")
    @Nullable
    private String appProtocol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    @Nullable
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    @Nullable
    private String protocol;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DiscoveryV1EndpointPort appProtocol(@Nullable String appProtocol) {
        this.appProtocol = appProtocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:  * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).  * Kubernetes-defined prefixed names:   * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-   * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455   * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455  * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.")
    public String getAppProtocol() {
        return this.appProtocol;
    }

    public void setAppProtocol(@Nullable String appProtocol) {
        this.appProtocol = appProtocol;
    }

    public DiscoveryV1EndpointPort name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name represents the name of this port. All ports in an EndpointSlice must have a unique name. If the EndpointSlice is derived from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass DNS_LABEL validation: * must be no more than 63 characters long. * must consist of lower case alphanumeric characters or '-'. * must start and end with an alphanumeric character. Default is empty string.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public DiscoveryV1EndpointPort port(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="port represents the port number of the endpoint. If the EndpointSlice is derived from a Kubernetes service, this must be set to the service's target port. EndpointSlices used for other purposes may have a nil port.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public DiscoveryV1EndpointPort protocol(@Nullable String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="protocol represents the IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(@Nullable String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryV1EndpointPort discoveryV1EndpointPort = (DiscoveryV1EndpointPort)o;
        return Objects.equals(this.appProtocol, discoveryV1EndpointPort.appProtocol) && Objects.equals(this.name, discoveryV1EndpointPort.name) && Objects.equals(this.port, discoveryV1EndpointPort.port) && Objects.equals(this.protocol, discoveryV1EndpointPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DiscoveryV1EndpointPort {\n");
        sb.append("    appProtocol: ").append(this.toIndentedString(this.appProtocol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DiscoveryV1EndpointPort is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DiscoveryV1EndpointPort` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APP_PROTOCOL) != null && !jsonObj.get(SERIALIZED_NAME_APP_PROTOCOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APP_PROTOCOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `appProtocol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APP_PROTOCOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROTOCOL) != null && !jsonObj.get(SERIALIZED_NAME_PROTOCOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROTOCOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `protocol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROTOCOL).toString()));
        }
    }

    public static DiscoveryV1EndpointPort fromJson(String jsonString) throws IOException {
        return (DiscoveryV1EndpointPort)JSON.getGson().fromJson(jsonString, DiscoveryV1EndpointPort.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APP_PROTOCOL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PORT);
        openapiFields.add(SERIALIZED_NAME_PROTOCOL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DiscoveryV1EndpointPort.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DiscoveryV1EndpointPort.class));
            return new TypeAdapter<DiscoveryV1EndpointPort>(){

                public void write(JsonWriter out, DiscoveryV1EndpointPort value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DiscoveryV1EndpointPort read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DiscoveryV1EndpointPort.validateJsonElement(jsonElement);
                    return (DiscoveryV1EndpointPort)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

