/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1beta2DeviceClass;
import io.kubernetes.client.openapi.models.V1beta2DeviceClassList;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaim;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimList;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimTemplate;
import io.kubernetes.client.openapi.models.V1beta2ResourceClaimTemplateList;
import io.kubernetes.client.openapi.models.V1beta2ResourceSlice;
import io.kubernetes.client.openapi.models.V1beta2ResourceSliceList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ResourceV1beta2Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ResourceV1beta2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourceV1beta2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createDeviceClassCall(@Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2DeviceClass localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDeviceClassValidateBeforeCall(@Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDeviceClass(Async)");
        }
        return this.createDeviceClassCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2DeviceClass> createDeviceClassWithHttpInfo(@Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createDeviceClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createDeviceClassAsync(@Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.createDeviceClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateDeviceClassRequest createDeviceClass(@Nonnull V1beta2DeviceClass body) {
        return new APIcreateDeviceClassRequest(body);
    }

    private Call createNamespacedResourceClaimCall(@Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedResourceClaimValidateBeforeCall(@Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedResourceClaim(Async)");
        }
        return this.createNamespacedResourceClaimCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> createNamespacedResourceClaimWithHttpInfo(@Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedResourceClaimAsync(@Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedResourceClaimRequest createNamespacedResourceClaim(@Nonnull String namespace, @Nonnull V1beta2ResourceClaim body) {
        return new APIcreateNamespacedResourceClaimRequest(namespace, body);
    }

    private Call createNamespacedResourceClaimTemplateCall(@Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceClaimTemplate localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedResourceClaimTemplate(Async)");
        }
        return this.createNamespacedResourceClaimTemplateCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplate> createNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimTemplateValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedResourceClaimTemplateAsync(@Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimTemplateValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedResourceClaimTemplateRequest createNamespacedResourceClaimTemplate(@Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body) {
        return new APIcreateNamespacedResourceClaimTemplateRequest(namespace, body);
    }

    private Call createResourceSliceCall(@Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceSlice localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createResourceSliceValidateBeforeCall(@Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createResourceSlice(Async)");
        }
        return this.createResourceSliceCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceSlice> createResourceSliceWithHttpInfo(@Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createResourceSliceValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createResourceSliceAsync(@Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.createResourceSliceValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateResourceSliceRequest createResourceSlice(@Nonnull V1beta2ResourceSlice body) {
        return new APIcreateResourceSliceRequest(body);
    }

    private Call deleteCollectionDeviceClassCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionDeviceClassValidateBeforeCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionDeviceClassCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionDeviceClassWithHttpInfo(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionDeviceClassAsync(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionDeviceClassRequest deleteCollectionDeviceClass() {
        return new APIdeleteCollectionDeviceClassRequest();
    }

    private Call deleteCollectionNamespacedResourceClaimCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedResourceClaimValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedResourceClaim(Async)");
        }
        return this.deleteCollectionNamespacedResourceClaimCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedResourceClaimWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedResourceClaimAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedResourceClaimRequest deleteCollectionNamespacedResourceClaim(@Nonnull String namespace) {
        return new APIdeleteCollectionNamespacedResourceClaimRequest(namespace);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedResourceClaimTemplate(Async)");
        }
        return this.deleteCollectionNamespacedResourceClaimTemplateCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedResourceClaimTemplateRequest deleteCollectionNamespacedResourceClaimTemplate(@Nonnull String namespace) {
        return new APIdeleteCollectionNamespacedResourceClaimTemplateRequest(namespace);
    }

    private Call deleteCollectionResourceSliceCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionResourceSliceValidateBeforeCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionResourceSliceCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionResourceSliceWithHttpInfo(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceSliceValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionResourceSliceAsync(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceSliceValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionResourceSliceRequest deleteCollectionResourceSlice() {
        return new APIdeleteCollectionResourceSliceRequest();
    }

    private Call deleteDeviceClassCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDeviceClassValidateBeforeCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDeviceClass(Async)");
        }
        return this.deleteDeviceClassCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1beta2DeviceClass> deleteDeviceClassWithHttpInfo(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteDeviceClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteDeviceClassAsync(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.deleteDeviceClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteDeviceClassRequest deleteDeviceClass(@Nonnull String name) {
        return new APIdeleteDeviceClassRequest(name);
    }

    private Call deleteNamespacedResourceClaimCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedResourceClaimValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedResourceClaim(Async)");
        }
        return this.deleteNamespacedResourceClaimCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> deleteNamespacedResourceClaimWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedResourceClaimAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedResourceClaimRequest deleteNamespacedResourceClaim(@Nonnull String name, @Nonnull String namespace) {
        return new APIdeleteNamespacedResourceClaimRequest(name, namespace);
    }

    private Call deleteNamespacedResourceClaimTemplateCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedResourceClaimTemplate(Async)");
        }
        return this.deleteNamespacedResourceClaimTemplateCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplate> deleteNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedResourceClaimTemplateAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedResourceClaimTemplateRequest deleteNamespacedResourceClaimTemplate(@Nonnull String name, @Nonnull String namespace) {
        return new APIdeleteNamespacedResourceClaimTemplateRequest(name, namespace);
    }

    private Call deleteResourceSliceCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteResourceSliceValidateBeforeCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteResourceSlice(Async)");
        }
        return this.deleteResourceSliceCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1beta2ResourceSlice> deleteResourceSliceWithHttpInfo(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteResourceSliceValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteResourceSliceAsync(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.deleteResourceSliceValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteResourceSliceRequest deleteResourceSlice(@Nonnull String name) {
        return new APIdeleteResourceSliceRequest(name);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listDeviceClassCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeviceClassValidateBeforeCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listDeviceClassCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1beta2DeviceClassList> listDeviceClassWithHttpInfo(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listDeviceClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClassList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeviceClassAsync(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1beta2DeviceClassList> _callback) throws ApiException {
        Call localVarCall = this.listDeviceClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClassList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeviceClassRequest listDeviceClass() {
        return new APIlistDeviceClassRequest();
    }

    private Call listNamespacedResourceClaimCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedResourceClaimValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedResourceClaim(Async)");
        }
        return this.listNamespacedResourceClaimCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimList> listNamespacedResourceClaimWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedResourceClaimAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1beta2ResourceClaimList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedResourceClaimRequest listNamespacedResourceClaim(@Nonnull String namespace) {
        return new APIlistNamespacedResourceClaimRequest(namespace);
    }

    private Call listNamespacedResourceClaimTemplateCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedResourceClaimTemplate(Async)");
        }
        return this.listNamespacedResourceClaimTemplateCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplateList> listNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplateList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedResourceClaimTemplateAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1beta2ResourceClaimTemplateList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplateList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedResourceClaimTemplateRequest listNamespacedResourceClaimTemplate(@Nonnull String namespace) {
        return new APIlistNamespacedResourceClaimTemplateRequest(namespace);
    }

    private Call listResourceClaimForAllNamespacesCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceclaims";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClaimForAllNamespacesValidateBeforeCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listResourceClaimForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimList> listResourceClaimForAllNamespacesWithHttpInfo(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listResourceClaimForAllNamespacesAsync(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1beta2ResourceClaimList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistResourceClaimForAllNamespacesRequest listResourceClaimForAllNamespaces() {
        return new APIlistResourceClaimForAllNamespacesRequest();
    }

    private Call listResourceClaimTemplateForAllNamespacesCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceclaimtemplates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClaimTemplateForAllNamespacesValidateBeforeCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listResourceClaimTemplateForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplateList> listResourceClaimTemplateForAllNamespacesWithHttpInfo(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplateList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listResourceClaimTemplateForAllNamespacesAsync(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1beta2ResourceClaimTemplateList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplateList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistResourceClaimTemplateForAllNamespacesRequest listResourceClaimTemplateForAllNamespaces() {
        return new APIlistResourceClaimTemplateForAllNamespacesRequest();
    }

    private Call listResourceSliceCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceSliceValidateBeforeCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listResourceSliceCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1beta2ResourceSliceList> listResourceSliceWithHttpInfo(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceSliceValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSliceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listResourceSliceAsync(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1beta2ResourceSliceList> _callback) throws ApiException {
        Call localVarCall = this.listResourceSliceValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSliceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistResourceSliceRequest listResourceSlice() {
        return new APIlistResourceSliceRequest();
    }

    private Call patchDeviceClassCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchDeviceClassValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchDeviceClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchDeviceClass(Async)");
        }
        return this.patchDeviceClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1beta2DeviceClass> patchDeviceClassWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchDeviceClassAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.patchDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchDeviceClassRequest patchDeviceClass(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchDeviceClassRequest(name, body);
    }

    private Call patchNamespacedResourceClaimCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaim(Async)");
        }
        return this.patchNamespacedResourceClaimCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> patchNamespacedResourceClaimWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedResourceClaimAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedResourceClaimRequest patchNamespacedResourceClaim(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedResourceClaimRequest(name, namespace, body);
    }

    private Call patchNamespacedResourceClaimStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        return this.patchNamespacedResourceClaimStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> patchNamespacedResourceClaimStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedResourceClaimStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedResourceClaimStatusRequest patchNamespacedResourceClaimStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedResourceClaimStatusRequest(name, namespace, body);
    }

    private Call patchNamespacedResourceClaimTemplateCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        return this.patchNamespacedResourceClaimTemplateCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplate> patchNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedResourceClaimTemplateAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedResourceClaimTemplateRequest patchNamespacedResourceClaimTemplate(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedResourceClaimTemplateRequest(name, namespace, body);
    }

    private Call patchResourceSliceCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchResourceSliceValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchResourceSlice(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchResourceSlice(Async)");
        }
        return this.patchResourceSliceCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1beta2ResourceSlice> patchResourceSliceWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchResourceSliceAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.patchResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchResourceSliceRequest patchResourceSlice(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchResourceSliceRequest(name, body);
    }

    private Call readDeviceClassCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readDeviceClassValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readDeviceClass(Async)");
        }
        return this.readDeviceClassCall(name, pretty, _callback);
    }

    private ApiResponse<V1beta2DeviceClass> readDeviceClassWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readDeviceClassValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readDeviceClassAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.readDeviceClassValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadDeviceClassRequest readDeviceClass(@Nonnull String name) {
        return new APIreadDeviceClassRequest(name);
    }

    private Call readNamespacedResourceClaimCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaim(Async)");
        }
        return this.readNamespacedResourceClaimCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> readNamespacedResourceClaimWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedResourceClaimAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedResourceClaimRequest readNamespacedResourceClaim(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedResourceClaimRequest(name, namespace);
    }

    private Call readNamespacedResourceClaimStatusCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaimStatus(Async)");
        }
        return this.readNamespacedResourceClaimStatusCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> readNamespacedResourceClaimStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedResourceClaimStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedResourceClaimStatusRequest readNamespacedResourceClaimStatus(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedResourceClaimStatusRequest(name, namespace);
    }

    private Call readNamespacedResourceClaimTemplateCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaimTemplate(Async)");
        }
        return this.readNamespacedResourceClaimTemplateCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplate> readNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedResourceClaimTemplateAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedResourceClaimTemplateRequest readNamespacedResourceClaimTemplate(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedResourceClaimTemplateRequest(name, namespace);
    }

    private Call readResourceSliceCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readResourceSliceValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readResourceSlice(Async)");
        }
        return this.readResourceSliceCall(name, pretty, _callback);
    }

    private ApiResponse<V1beta2ResourceSlice> readResourceSliceWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readResourceSliceValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readResourceSliceAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.readResourceSliceValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadResourceSliceRequest readResourceSlice(@Nonnull String name) {
        return new APIreadResourceSliceRequest(name);
    }

    private Call replaceDeviceClassCall(@Nonnull String name, @Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2DeviceClass localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/deviceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceDeviceClassValidateBeforeCall(@Nonnull String name, @Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceDeviceClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceDeviceClass(Async)");
        }
        return this.replaceDeviceClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2DeviceClass> replaceDeviceClassWithHttpInfo(@Nonnull String name, @Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceDeviceClassAsync(@Nonnull String name, @Nonnull V1beta2DeviceClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.replaceDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceDeviceClassRequest replaceDeviceClass(@Nonnull String name, @Nonnull V1beta2DeviceClass body) {
        return new APIreplaceDeviceClassRequest(name, body);
    }

    private Call replaceNamespacedResourceClaimCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaim(Async)");
        }
        return this.replaceNamespacedResourceClaimCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> replaceNamespacedResourceClaimWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedResourceClaimAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedResourceClaimRequest replaceNamespacedResourceClaim(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body) {
        return new APIreplaceNamespacedResourceClaimRequest(name, namespace, body);
    }

    private Call replaceNamespacedResourceClaimStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaims/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        return this.replaceNamespacedResourceClaimStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceClaim> replaceNamespacedResourceClaimStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedResourceClaimStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedResourceClaimStatusRequest replaceNamespacedResourceClaimStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaim body) {
        return new APIreplaceNamespacedResourceClaimStatusRequest(name, namespace, body);
    }

    private Call replaceNamespacedResourceClaimTemplateCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceClaimTemplate localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimTemplateValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        return this.replaceNamespacedResourceClaimTemplateCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceClaimTemplate> replaceNamespacedResourceClaimTemplateWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedResourceClaimTemplateAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedResourceClaimTemplateRequest replaceNamespacedResourceClaimTemplate(@Nonnull String name, @Nonnull String namespace, @Nonnull V1beta2ResourceClaimTemplate body) {
        return new APIreplaceNamespacedResourceClaimTemplateRequest(name, namespace, body);
    }

    private Call replaceResourceSliceCall(@Nonnull String name, @Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1beta2ResourceSlice localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1beta2/resourceslices/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceResourceSliceValidateBeforeCall(@Nonnull String name, @Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceResourceSlice(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceResourceSlice(Async)");
        }
        return this.replaceResourceSliceCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1beta2ResourceSlice> replaceResourceSliceWithHttpInfo(@Nonnull String name, @Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceResourceSliceAsync(@Nonnull String name, @Nonnull V1beta2ResourceSlice body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.replaceResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta2ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceResourceSliceRequest replaceResourceSlice(@Nonnull String name, @Nonnull V1beta2ResourceSlice body) {
        return new APIreplaceResourceSliceRequest(name, body);
    }

    public class APIcreateDeviceClassRequest {
        @Nonnull
        private final V1beta2DeviceClass body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateDeviceClassRequest(V1beta2DeviceClass body) {
            this.body = body;
        }

        public APIcreateDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateDeviceClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateDeviceClassRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateDeviceClassRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.createDeviceClassCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2DeviceClass execute() throws ApiException {
            ApiResponse<V1beta2DeviceClass> localVarResp = ResourceV1beta2Api.this.createDeviceClassWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2DeviceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.createDeviceClassWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
            return ResourceV1beta2Api.this.createDeviceClassAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedResourceClaimRequest {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1beta2ResourceClaim body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedResourceClaimRequest(@Nonnull String namespace, V1beta2ResourceClaim body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedResourceClaimRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedResourceClaimRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedResourceClaimRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.createNamespacedResourceClaimCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.createNamespacedResourceClaimWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.createNamespacedResourceClaimWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.createNamespacedResourceClaimAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1beta2ResourceClaimTemplate body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedResourceClaimTemplateRequest(@Nonnull String namespace, V1beta2ResourceClaimTemplate body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.createNamespacedResourceClaimTemplateCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplate> localVarResp = ResourceV1beta2Api.this.createNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.createNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1beta2Api.this.createNamespacedResourceClaimTemplateAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateResourceSliceRequest {
        @Nonnull
        private final V1beta2ResourceSlice body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateResourceSliceRequest(V1beta2ResourceSlice body) {
            this.body = body;
        }

        public APIcreateResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateResourceSliceRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateResourceSliceRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateResourceSliceRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.createResourceSliceCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceSlice execute() throws ApiException {
            ApiResponse<V1beta2ResourceSlice> localVarResp = ResourceV1beta2Api.this.createResourceSliceWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceSlice> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.createResourceSliceWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
            return ResourceV1beta2Api.this.createResourceSliceAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionDeviceClassRequest {
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionDeviceClassRequest() {
        }

        public APIdeleteCollectionDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionDeviceClassRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionDeviceClassCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = ResourceV1beta2Api.this.deleteCollectionDeviceClassWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionDeviceClassWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionDeviceClassAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedResourceClaimRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedResourceClaimRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedResourceClaimTemplateRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimTemplateCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionNamespacedResourceClaimTemplateAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionResourceSliceRequest {
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionResourceSliceRequest() {
        }

        public APIdeleteCollectionResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionResourceSliceRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionResourceSliceCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = ResourceV1beta2Api.this.deleteCollectionResourceSliceWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionResourceSliceWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteCollectionResourceSliceAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteDeviceClassRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteDeviceClassRequest(String name) {
            this.name = name;
        }

        public APIdeleteDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteDeviceClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteDeviceClassRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteDeviceClassRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteDeviceClassRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteDeviceClassRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteDeviceClassRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteDeviceClassCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1beta2DeviceClass execute() throws ApiException {
            ApiResponse<V1beta2DeviceClass> localVarResp = ResourceV1beta2Api.this.deleteDeviceClassWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2DeviceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteDeviceClassWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteDeviceClassAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedResourceClaimRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedResourceClaimRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteNamespacedResourceClaimCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.deleteNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteNamespacedResourceClaimAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedResourceClaimTemplateRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1beta2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplate> localVarResp = ResourceV1beta2Api.this.deleteNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteResourceSliceRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteResourceSliceRequest(String name) {
            this.name = name;
        }

        public APIdeleteResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteResourceSliceRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteResourceSliceRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteResourceSliceRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteResourceSliceRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteResourceSliceRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteResourceSliceRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteResourceSliceCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1beta2ResourceSlice execute() throws ApiException {
            ApiResponse<V1beta2ResourceSlice> localVarResp = ResourceV1beta2Api.this.deleteResourceSliceWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceSlice> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.deleteResourceSliceWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
            return ResourceV1beta2Api.this.deleteResourceSliceAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = ResourceV1beta2Api.this.getAPIResourcesWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistDeviceClassRequest {
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistDeviceClassRequest() {
        }

        public APIlistDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistDeviceClassRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistDeviceClassRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistDeviceClassRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistDeviceClassRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistDeviceClassRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeviceClassRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistDeviceClassRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistDeviceClassRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistDeviceClassRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistDeviceClassRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.listDeviceClassCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1beta2DeviceClassList execute() throws ApiException {
            ApiResponse<V1beta2DeviceClassList> localVarResp = ResourceV1beta2Api.this.listDeviceClassWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2DeviceClassList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.listDeviceClassWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1beta2DeviceClassList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.listDeviceClassAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedResourceClaimRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedResourceClaimRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.listNamespacedResourceClaimCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1beta2ResourceClaimList execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimList> localVarResp = ResourceV1beta2Api.this.listNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.listNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.listNamespacedResourceClaimAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedResourceClaimTemplateRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.listNamespacedResourceClaimTemplateCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1beta2ResourceClaimTemplateList execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplateList> localVarResp = ResourceV1beta2Api.this.listNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplateList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.listNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplateList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.listNamespacedResourceClaimTemplateAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistResourceClaimForAllNamespacesRequest {
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String pretty;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistResourceClaimForAllNamespacesRequest() {
        }

        public APIlistResourceClaimForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.listResourceClaimForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1beta2ResourceClaimList execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimList> localVarResp = ResourceV1beta2Api.this.listResourceClaimForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.listResourceClaimForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.listResourceClaimForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistResourceClaimTemplateForAllNamespacesRequest {
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String pretty;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistResourceClaimTemplateForAllNamespacesRequest() {
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.listResourceClaimTemplateForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1beta2ResourceClaimTemplateList execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplateList> localVarResp = ResourceV1beta2Api.this.listResourceClaimTemplateForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplateList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.listResourceClaimTemplateForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplateList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.listResourceClaimTemplateForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistResourceSliceRequest {
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistResourceSliceRequest() {
        }

        public APIlistResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistResourceSliceRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistResourceSliceRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistResourceSliceRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistResourceSliceRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistResourceSliceRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistResourceSliceRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistResourceSliceRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistResourceSliceRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistResourceSliceRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistResourceSliceRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.listResourceSliceCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1beta2ResourceSliceList execute() throws ApiException {
            ApiResponse<V1beta2ResourceSliceList> localVarResp = ResourceV1beta2Api.this.listResourceSliceWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceSliceList> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.listResourceSliceWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceSliceList> _callback) throws ApiException {
            return ResourceV1beta2Api.this.listResourceSliceAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchDeviceClassRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchDeviceClassRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchDeviceClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchDeviceClassRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchDeviceClassRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchDeviceClassRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchDeviceClassCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1beta2DeviceClass execute() throws ApiException {
            ApiResponse<V1beta2DeviceClass> localVarResp = ResourceV1beta2Api.this.patchDeviceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2DeviceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.patchDeviceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchDeviceClassAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedResourceClaimRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedResourceClaimRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.patchNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedResourceClaimStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedResourceClaimStatusRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedResourceClaimStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.patchNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedResourceClaimTemplateRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1beta2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplate> localVarResp = ResourceV1beta2Api.this.patchNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchResourceSliceRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchResourceSliceRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchResourceSliceRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchResourceSliceRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchResourceSliceRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchResourceSliceRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchResourceSliceCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1beta2ResourceSlice execute() throws ApiException {
            ApiResponse<V1beta2ResourceSlice> localVarResp = ResourceV1beta2Api.this.patchResourceSliceWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceSlice> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.patchResourceSliceWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
            return ResourceV1beta2Api.this.patchResourceSliceAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadDeviceClassRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadDeviceClassRequest(String name) {
            this.name = name;
        }

        public APIreadDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.readDeviceClassCall(this.name, this.pretty, _callback);
        }

        public V1beta2DeviceClass execute() throws ApiException {
            ApiResponse<V1beta2DeviceClass> localVarResp = ResourceV1beta2Api.this.readDeviceClassWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2DeviceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.readDeviceClassWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
            return ResourceV1beta2Api.this.readDeviceClassAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedResourceClaimRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedResourceClaimRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.readNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedResourceClaimStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedResourceClaimStatusRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedResourceClaimStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimStatusCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.readNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimStatusAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedResourceClaimTemplateRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1beta2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplate> localVarResp = ResourceV1beta2Api.this.readNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1beta2Api.this.readNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadResourceSliceRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadResourceSliceRequest(String name) {
            this.name = name;
        }

        public APIreadResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.readResourceSliceCall(this.name, this.pretty, _callback);
        }

        public V1beta2ResourceSlice execute() throws ApiException {
            ApiResponse<V1beta2ResourceSlice> localVarResp = ResourceV1beta2Api.this.readResourceSliceWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceSlice> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.readResourceSliceWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
            return ResourceV1beta2Api.this.readResourceSliceAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreplaceDeviceClassRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1beta2DeviceClass body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceDeviceClassRequest(@Nonnull String name, V1beta2DeviceClass body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceDeviceClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceDeviceClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceDeviceClassRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceDeviceClassRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceDeviceClassCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2DeviceClass execute() throws ApiException {
            ApiResponse<V1beta2DeviceClass> localVarResp = ResourceV1beta2Api.this.replaceDeviceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2DeviceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.replaceDeviceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2DeviceClass> _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceDeviceClassAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedResourceClaimRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1beta2ResourceClaim body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedResourceClaimRequest(@Nonnull String name, @Nonnull String namespace, V1beta2ResourceClaim body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedResourceClaimRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedResourceClaimRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedResourceClaimRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedResourceClaimRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.replaceNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedResourceClaimStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1beta2ResourceClaim body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedResourceClaimStatusRequest(@Nonnull String name, @Nonnull String namespace, V1beta2ResourceClaim body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceClaim execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaim> localVarResp = ResourceV1beta2Api.this.replaceNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaim> _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedResourceClaimTemplateRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1beta2ResourceClaimTemplate body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedResourceClaimTemplateRequest(@Nonnull String name, @Nonnull String namespace, V1beta2ResourceClaimTemplate body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse<V1beta2ResourceClaimTemplate> localVarResp = ResourceV1beta2Api.this.replaceNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceResourceSliceRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1beta2ResourceSlice body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceResourceSliceRequest(@Nonnull String name, V1beta2ResourceSlice body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceResourceSliceRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceResourceSliceRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceResourceSliceRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceResourceSliceRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceResourceSliceCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1beta2ResourceSlice execute() throws ApiException {
            ApiResponse<V1beta2ResourceSlice> localVarResp = ResourceV1beta2Api.this.replaceResourceSliceWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1beta2ResourceSlice> executeWithHttpInfo() throws ApiException {
            return ResourceV1beta2Api.this.replaceResourceSliceWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1beta2ResourceSlice> _callback) throws ApiException {
            return ResourceV1beta2Api.this.replaceResourceSliceAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

