/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class LogsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public LogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call logFileHandlerCall(@Nonnull String logpath, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/logs/{logpath}".replace("{logpath}", this.localVarApiClient.escapeString(logpath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logFileHandlerValidateBeforeCall(@Nonnull String logpath, ApiCallback _callback) throws ApiException {
        if (logpath == null) {
            throw new ApiException("Missing the required parameter 'logpath' when calling logFileHandler(Async)");
        }
        return this.logFileHandlerCall(logpath, _callback);
    }

    private ApiResponse<Void> logFileHandlerWithHttpInfo(@Nonnull String logpath) throws ApiException {
        Call localVarCall = this.logFileHandlerValidateBeforeCall(logpath, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call logFileHandlerAsync(@Nonnull String logpath, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.logFileHandlerValidateBeforeCall(logpath, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIlogFileHandlerRequest logFileHandler(@Nonnull String logpath) {
        return new APIlogFileHandlerRequest(logpath);
    }

    private Call logFileListHandlerCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/logs/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logFileListHandlerValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.logFileListHandlerCall(_callback);
    }

    private ApiResponse<Void> logFileListHandlerWithHttpInfo() throws ApiException {
        Call localVarCall = this.logFileListHandlerValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call logFileListHandlerAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.logFileListHandlerValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIlogFileListHandlerRequest logFileListHandler() {
        return new APIlogFileListHandlerRequest();
    }

    public class APIlogFileHandlerRequest {
        @Nonnull
        private final String logpath;

        private APIlogFileHandlerRequest(String logpath) {
            this.logpath = logpath;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return LogsApi.this.logFileHandlerCall(this.logpath, _callback);
        }

        public void execute() throws ApiException {
            LogsApi.this.logFileHandlerWithHttpInfo(this.logpath);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsApi.this.logFileHandlerWithHttpInfo(this.logpath);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return LogsApi.this.logFileHandlerAsync(this.logpath, _callback);
        }
    }

    public class APIlogFileListHandlerRequest {
        private APIlogFileListHandlerRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return LogsApi.this.logFileListHandlerCall(_callback);
        }

        public void execute() throws ApiException {
            LogsApi.this.logFileListHandlerWithHttpInfo();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsApi.this.logFileListHandlerWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return LogsApi.this.logFileListHandlerAsync(_callback);
        }
    }
}

