/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscaler;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscalerList;
import io.kubernetes.client.openapi.models.V1Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AutoscalingV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AutoscalingV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public AutoscalingV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createNamespacedHorizontalPodAutoscalerCall(@Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1HorizontalPodAutoscaler localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.createNamespacedHorizontalPodAutoscalerCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> createNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedHorizontalPodAutoscalerValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedHorizontalPodAutoscalerAsync(@Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedHorizontalPodAutoscalerValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedHorizontalPodAutoscalerRequest createNamespacedHorizontalPodAutoscaler(@Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body) {
        return new APIcreateNamespacedHorizontalPodAutoscalerRequest(namespace, body);
    }

    private Call deleteCollectionNamespacedHorizontalPodAutoscalerCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.deleteCollectionNamespacedHorizontalPodAutoscalerCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedHorizontalPodAutoscalerValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedHorizontalPodAutoscalerAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedHorizontalPodAutoscalerValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest deleteCollectionNamespacedHorizontalPodAutoscaler(@Nonnull String namespace) {
        return new APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest(namespace);
    }

    private Call deleteNamespacedHorizontalPodAutoscalerCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.deleteNamespacedHorizontalPodAutoscalerCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedHorizontalPodAutoscalerAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedHorizontalPodAutoscalerRequest deleteNamespacedHorizontalPodAutoscaler(@Nonnull String name, @Nonnull String namespace) {
        return new APIdeleteNamespacedHorizontalPodAutoscalerRequest(name, namespace);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/autoscaling/v1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listHorizontalPodAutoscalerForAllNamespacesCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/autoscaling/v1/horizontalpodautoscalers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listHorizontalPodAutoscalerForAllNamespacesValidateBeforeCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listHorizontalPodAutoscalerForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscalerList> listHorizontalPodAutoscalerForAllNamespacesWithHttpInfo(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listHorizontalPodAutoscalerForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscalerList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listHorizontalPodAutoscalerForAllNamespacesAsync(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1HorizontalPodAutoscalerList> _callback) throws ApiException {
        Call localVarCall = this.listHorizontalPodAutoscalerForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscalerList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistHorizontalPodAutoscalerForAllNamespacesRequest listHorizontalPodAutoscalerForAllNamespaces() {
        return new APIlistHorizontalPodAutoscalerForAllNamespacesRequest();
    }

    private Call listNamespacedHorizontalPodAutoscalerCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.listNamespacedHorizontalPodAutoscalerCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscalerList> listNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedHorizontalPodAutoscalerValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscalerList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedHorizontalPodAutoscalerAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1HorizontalPodAutoscalerList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedHorizontalPodAutoscalerValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscalerList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedHorizontalPodAutoscalerRequest listNamespacedHorizontalPodAutoscaler(@Nonnull String namespace) {
        return new APIlistNamespacedHorizontalPodAutoscalerRequest(namespace);
    }

    private Call patchNamespacedHorizontalPodAutoscalerCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.patchNamespacedHorizontalPodAutoscalerCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> patchNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedHorizontalPodAutoscalerAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedHorizontalPodAutoscalerRequest patchNamespacedHorizontalPodAutoscaler(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedHorizontalPodAutoscalerRequest(name, namespace, body);
    }

    private Call patchNamespacedHorizontalPodAutoscalerStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        return this.patchNamespacedHorizontalPodAutoscalerStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> patchNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedHorizontalPodAutoscalerStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedHorizontalPodAutoscalerStatusRequest patchNamespacedHorizontalPodAutoscalerStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedHorizontalPodAutoscalerStatusRequest(name, namespace, body);
    }

    private Call readNamespacedHorizontalPodAutoscalerCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.readNamespacedHorizontalPodAutoscalerCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> readNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedHorizontalPodAutoscalerAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedHorizontalPodAutoscalerRequest readNamespacedHorizontalPodAutoscaler(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedHorizontalPodAutoscalerRequest(name, namespace);
    }

    private Call readNamespacedHorizontalPodAutoscalerStatusCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        return this.readNamespacedHorizontalPodAutoscalerStatusCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> readNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedHorizontalPodAutoscalerStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedHorizontalPodAutoscalerStatusRequest readNamespacedHorizontalPodAutoscalerStatus(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedHorizontalPodAutoscalerStatusRequest(name, namespace);
    }

    private Call replaceNamespacedHorizontalPodAutoscalerCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1HorizontalPodAutoscaler localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedHorizontalPodAutoscalerValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedHorizontalPodAutoscaler(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedHorizontalPodAutoscaler(Async)");
        }
        return this.replaceNamespacedHorizontalPodAutoscalerCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> replaceNamespacedHorizontalPodAutoscalerWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedHorizontalPodAutoscalerAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedHorizontalPodAutoscalerValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedHorizontalPodAutoscalerRequest replaceNamespacedHorizontalPodAutoscaler(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body) {
        return new APIreplaceNamespacedHorizontalPodAutoscalerRequest(name, namespace, body);
    }

    private Call replaceNamespacedHorizontalPodAutoscalerStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1HorizontalPodAutoscaler localVarPostBody = body;
        String localVarPath = "/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedHorizontalPodAutoscalerStatus(Async)");
        }
        return this.replaceNamespacedHorizontalPodAutoscalerStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1HorizontalPodAutoscaler> replaceNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedHorizontalPodAutoscalerStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedHorizontalPodAutoscalerStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1HorizontalPodAutoscaler>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest replaceNamespacedHorizontalPodAutoscalerStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1HorizontalPodAutoscaler body) {
        return new APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest(name, namespace, body);
    }

    public class APIcreateNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1HorizontalPodAutoscaler body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedHorizontalPodAutoscalerRequest(@Nonnull String namespace, V1HorizontalPodAutoscaler body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedHorizontalPodAutoscalerRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedHorizontalPodAutoscalerRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedHorizontalPodAutoscalerRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.createNamespacedHorizontalPodAutoscalerCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.createNamespacedHorizontalPodAutoscalerWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.createNamespacedHorizontalPodAutoscalerWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.createNamespacedHorizontalPodAutoscalerAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedHorizontalPodAutoscalerRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.deleteCollectionNamespacedHorizontalPodAutoscalerCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = AutoscalingV1Api.this.deleteCollectionNamespacedHorizontalPodAutoscalerWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.deleteCollectionNamespacedHorizontalPodAutoscalerWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return AutoscalingV1Api.this.deleteCollectionNamespacedHorizontalPodAutoscalerAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedHorizontalPodAutoscalerRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedHorizontalPodAutoscalerRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.deleteNamespacedHorizontalPodAutoscalerCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = AutoscalingV1Api.this.deleteNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.deleteNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return AutoscalingV1Api.this.deleteNamespacedHorizontalPodAutoscalerAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = AutoscalingV1Api.this.getAPIResourcesWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return AutoscalingV1Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistHorizontalPodAutoscalerForAllNamespacesRequest {
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String pretty;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistHorizontalPodAutoscalerForAllNamespacesRequest() {
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistHorizontalPodAutoscalerForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.listHorizontalPodAutoscalerForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1HorizontalPodAutoscalerList execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscalerList> localVarResp = AutoscalingV1Api.this.listHorizontalPodAutoscalerForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscalerList> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.listHorizontalPodAutoscalerForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscalerList> _callback) throws ApiException {
            return AutoscalingV1Api.this.listHorizontalPodAutoscalerForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedHorizontalPodAutoscalerRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedHorizontalPodAutoscalerRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.listNamespacedHorizontalPodAutoscalerCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1HorizontalPodAutoscalerList execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscalerList> localVarResp = AutoscalingV1Api.this.listNamespacedHorizontalPodAutoscalerWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscalerList> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.listNamespacedHorizontalPodAutoscalerWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscalerList> _callback) throws ApiException {
            return AutoscalingV1Api.this.listNamespacedHorizontalPodAutoscalerAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedHorizontalPodAutoscalerRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedHorizontalPodAutoscalerStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedHorizontalPodAutoscalerStatusRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedHorizontalPodAutoscalerStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.patchNamespacedHorizontalPodAutoscalerStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedHorizontalPodAutoscalerRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedHorizontalPodAutoscalerStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedHorizontalPodAutoscalerStatusRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedHorizontalPodAutoscalerStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerStatusCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.readNamespacedHorizontalPodAutoscalerStatusAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreplaceNamespacedHorizontalPodAutoscalerRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1HorizontalPodAutoscaler body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedHorizontalPodAutoscalerRequest(@Nonnull String name, @Nonnull String namespace, V1HorizontalPodAutoscaler body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1HorizontalPodAutoscaler body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest(@Nonnull String name, @Nonnull String namespace, V1HorizontalPodAutoscaler body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedHorizontalPodAutoscalerStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1HorizontalPodAutoscaler execute() throws ApiException {
            ApiResponse<V1HorizontalPodAutoscaler> localVarResp = AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1HorizontalPodAutoscaler> executeWithHttpInfo() throws ApiException {
            return AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1HorizontalPodAutoscaler> _callback) throws ApiException {
            return AutoscalingV1Api.this.replaceNamespacedHorizontalPodAutoscalerStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

