/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeer;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.")
public class V1NetworkPolicyIngressRule {
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private List<V1NetworkPolicyPeer> from = null;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1NetworkPolicyPort> ports = null;

    public V1NetworkPolicyIngressRule from(List<V1NetworkPolicyPeer> from) {
        this.from = from;
        return this;
    }

    public V1NetworkPolicyIngressRule addFromItem(V1NetworkPolicyPeer fromItem) {
        if (this.from == null) {
            this.from = new ArrayList<V1NetworkPolicyPeer>();
        }
        this.from.add(fromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.")
    public List<V1NetworkPolicyPeer> getFrom() {
        return this.from;
    }

    public void setFrom(List<V1NetworkPolicyPeer> from) {
        this.from = from;
    }

    public V1NetworkPolicyIngressRule ports(List<V1NetworkPolicyPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1NetworkPolicyIngressRule addPortsItem(V1NetworkPolicyPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1NetworkPolicyPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.")
    public List<V1NetworkPolicyPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1NetworkPolicyPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicyIngressRule v1NetworkPolicyIngressRule = (V1NetworkPolicyIngressRule)o;
        return Objects.equals(this.from, v1NetworkPolicyIngressRule.from) && Objects.equals(this.ports, v1NetworkPolicyIngressRule.ports);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicyIngressRule {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

