/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClassSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.  This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.")
public class V1alpha3DeviceClass
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_SPEC = "spec";
    @SerializedName(value="spec")
    private V1alpha3DeviceClassSpec spec;

    public V1alpha3DeviceClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha3DeviceClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha3DeviceClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha3DeviceClass spec(V1alpha3DeviceClassSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha3DeviceClassSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1alpha3DeviceClassSpec spec) {
        this.spec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3DeviceClass v1alpha3DeviceClass = (V1alpha3DeviceClass)o;
        return Objects.equals(this.apiVersion, v1alpha3DeviceClass.apiVersion) && Objects.equals(this.kind, v1alpha3DeviceClass.kind) && Objects.equals(this.metadata, v1alpha3DeviceClass.metadata) && Objects.equals(this.spec, v1alpha3DeviceClass.spec);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3DeviceClass {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

