/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha3Counter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.  The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.")
public class V1alpha3CounterSet {
    public static final String SERIALIZED_NAME_COUNTERS = "counters";
    @SerializedName(value="counters")
    private Map<String, V1alpha3Counter> counters = new HashMap<String, V1alpha3Counter>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V1alpha3CounterSet counters(Map<String, V1alpha3Counter> counters) {
        this.counters = counters;
        return this;
    }

    public V1alpha3CounterSet putCountersItem(String key, V1alpha3Counter countersItem) {
        this.counters.put(key, countersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Counters defines the counters that will be consumed by the device. The name of each counter must be unique in that set and must be a DNS label.  To ensure this uniqueness, capacities defined by the vendor must be listed without the driver name as domain prefix in their name. All others must be listed with their domain prefix.  The maximum number of counters is 32.")
    public Map<String, V1alpha3Counter> getCounters() {
        return this.counters;
    }

    public void setCounters(Map<String, V1alpha3Counter> counters) {
        this.counters = counters;
    }

    public V1alpha3CounterSet name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="CounterSet is the name of the set from which the counters defined will be consumed.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3CounterSet v1alpha3CounterSet = (V1alpha3CounterSet)o;
        return Objects.equals(this.counters, v1alpha3CounterSet.counters) && Objects.equals(this.name, v1alpha3CounterSet.name);
    }

    public int hashCode() {
        return Objects.hash(this.counters, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3CounterSet {\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

