/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="VolumeMountStatus shows status of volume mounts.")
public class V1VolumeMountStatus {
    public static final String SERIALIZED_NAME_MOUNT_PATH = "mountPath";
    @SerializedName(value="mountPath")
    private String mountPath;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_RECURSIVE_READ_ONLY = "recursiveReadOnly";
    @SerializedName(value="recursiveReadOnly")
    private String recursiveReadOnly;

    public V1VolumeMountStatus mountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @ApiModelProperty(required=true, value="MountPath corresponds to the original VolumeMount.")
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public V1VolumeMountStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name corresponds to the name of the original VolumeMount.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1VolumeMountStatus readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly corresponds to the original VolumeMount.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1VolumeMountStatus recursiveReadOnly(String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RecursiveReadOnly must be set to Disabled, Enabled, or unspecified (for non-readonly mounts). An IfPossible value in the original VolumeMount must be translated to Disabled or Enabled, depending on the mount result.")
    public String getRecursiveReadOnly() {
        return this.recursiveReadOnly;
    }

    public void setRecursiveReadOnly(String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeMountStatus v1VolumeMountStatus = (V1VolumeMountStatus)o;
        return Objects.equals(this.mountPath, v1VolumeMountStatus.mountPath) && Objects.equals(this.name, v1VolumeMountStatus.name) && Objects.equals(this.readOnly, v1VolumeMountStatus.readOnly) && Objects.equals(this.recursiveReadOnly, v1VolumeMountStatus.recursiveReadOnly);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.name, this.readOnly, this.recursiveReadOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeMountStatus {\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    recursiveReadOnly: ").append(this.toIndentedString(this.recursiveReadOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

