/*
Copyright 2025 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.models.V1beta2DeviceClaimConfiguration;
import io.kubernetes.client.openapi.models.V1beta2DeviceConstraint;
import io.kubernetes.client.openapi.models.V1beta2DeviceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * DeviceClaim defines how to request devices with a ResourceClaim.
 */
@ApiModel(description = "DeviceClaim defines how to request devices with a ResourceClaim.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-22T21:20:49.874193Z[Etc/UTC]")
public class V1beta2DeviceClaim {
  public static final String SERIALIZED_NAME_CONFIG = "config";
  @SerializedName(SERIALIZED_NAME_CONFIG)
  private List<V1beta2DeviceClaimConfiguration> config = null;

  public static final String SERIALIZED_NAME_CONSTRAINTS = "constraints";
  @SerializedName(SERIALIZED_NAME_CONSTRAINTS)
  private List<V1beta2DeviceConstraint> constraints = null;

  public static final String SERIALIZED_NAME_REQUESTS = "requests";
  @SerializedName(SERIALIZED_NAME_REQUESTS)
  private List<V1beta2DeviceRequest> requests = null;


  public V1beta2DeviceClaim config(List<V1beta2DeviceClaimConfiguration> config) {

    this.config = config;
    return this;
  }

  public V1beta2DeviceClaim addConfigItem(V1beta2DeviceClaimConfiguration configItem) {
    if (this.config == null) {
      this.config = new ArrayList<>();
    }
    this.config.add(configItem);
    return this;
  }

   /**
   * This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
   * @return config
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.")

  public List<V1beta2DeviceClaimConfiguration> getConfig() {
    return config;
  }


  public void setConfig(List<V1beta2DeviceClaimConfiguration> config) {
    this.config = config;
  }


  public V1beta2DeviceClaim constraints(List<V1beta2DeviceConstraint> constraints) {

    this.constraints = constraints;
    return this;
  }

  public V1beta2DeviceClaim addConstraintsItem(V1beta2DeviceConstraint constraintsItem) {
    if (this.constraints == null) {
      this.constraints = new ArrayList<>();
    }
    this.constraints.add(constraintsItem);
    return this;
  }

   /**
   * These constraints must be satisfied by the set of devices that get allocated for the claim.
   * @return constraints
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "These constraints must be satisfied by the set of devices that get allocated for the claim.")

  public List<V1beta2DeviceConstraint> getConstraints() {
    return constraints;
  }


  public void setConstraints(List<V1beta2DeviceConstraint> constraints) {
    this.constraints = constraints;
  }


  public V1beta2DeviceClaim requests(List<V1beta2DeviceRequest> requests) {

    this.requests = requests;
    return this;
  }

  public V1beta2DeviceClaim addRequestsItem(V1beta2DeviceRequest requestsItem) {
    if (this.requests == null) {
      this.requests = new ArrayList<>();
    }
    this.requests.add(requestsItem);
    return this;
  }

   /**
   * Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
   * @return requests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.")

  public List<V1beta2DeviceRequest> getRequests() {
    return requests;
  }


  public void setRequests(List<V1beta2DeviceRequest> requests) {
    this.requests = requests;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1beta2DeviceClaim v1beta2DeviceClaim = (V1beta2DeviceClaim) o;
    return Objects.equals(this.config, v1beta2DeviceClaim.config) &&
        Objects.equals(this.constraints, v1beta2DeviceClaim.constraints) &&
        Objects.equals(this.requests, v1beta2DeviceClaim.requests);
  }

  @Override
  public int hashCode() {
    return Objects.hash(config, constraints, requests);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1beta2DeviceClaim {\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    constraints: ").append(toIndentedString(constraints)).append("\n");
    sb.append("    requests: ").append(toIndentedString(requests)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
