/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ImageVolumeSource represents a image volume resource.")
public class V1ImageVolumeSource {
    public static final String SERIALIZED_NAME_PULL_POLICY = "pullPolicy";
    @SerializedName(value="pullPolicy")
    private String pullPolicy;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;

    public V1ImageVolumeSource pullPolicy(String pullPolicy) {
        this.pullPolicy = pullPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.")
    public String getPullPolicy() {
        return this.pullPolicy;
    }

    public void setPullPolicy(String pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    public V1ImageVolumeSource reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ImageVolumeSource v1ImageVolumeSource = (V1ImageVolumeSource)o;
        return Objects.equals(this.pullPolicy, v1ImageVolumeSource.pullPolicy) && Objects.equals(this.reference, v1ImageVolumeSource.reference);
    }

    public int hashCode() {
        return Objects.hash(this.pullPolicy, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ImageVolumeSource {\n");
        sb.append("    pullPolicy: ").append(this.toIndentedString(this.pullPolicy)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

