/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1alpha3DeviceAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="BasicDevice defines one device instance.")
public class V1alpha3BasicDevice {
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, V1alpha3DeviceAttribute> attributes = null;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, Quantity> capacity = null;

    public V1alpha3BasicDevice attributes(Map<String, V1alpha3DeviceAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public V1alpha3BasicDevice putAttributesItem(String key, V1alpha3DeviceAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, V1alpha3DeviceAttribute>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1alpha3DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, V1alpha3DeviceAttribute> attributes) {
        this.attributes = attributes;
    }

    public V1alpha3BasicDevice capacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1alpha3BasicDevice putCapacityItem(String key, Quantity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, Quantity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3BasicDevice v1alpha3BasicDevice = (V1alpha3BasicDevice)o;
        return Objects.equals(this.attributes, v1alpha3BasicDevice.attributes) && Objects.equals(this.capacity, v1alpha3BasicDevice.capacity);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.capacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3BasicDevice {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

