/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NonResourceRule;
import io.kubernetes.client.openapi.models.V1ResourceRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1SubjectRulesReviewStatus {
    public static final String SERIALIZED_NAME_EVALUATION_ERROR = "evaluationError";
    @SerializedName(value="evaluationError")
    private String evaluationError;
    public static final String SERIALIZED_NAME_INCOMPLETE = "incomplete";
    @SerializedName(value="incomplete")
    private Boolean incomplete;
    public static final String SERIALIZED_NAME_NON_RESOURCE_RULES = "nonResourceRules";
    @SerializedName(value="nonResourceRules")
    private List<V1NonResourceRule> nonResourceRules = new ArrayList<V1NonResourceRule>();
    public static final String SERIALIZED_NAME_RESOURCE_RULES = "resourceRules";
    @SerializedName(value="resourceRules")
    private List<V1ResourceRule> resourceRules = new ArrayList<V1ResourceRule>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1SubjectRulesReviewStatus evaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return this;
    }

    @Nullable
    public String getEvaluationError() {
        return this.evaluationError;
    }

    public void setEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
    }

    public V1SubjectRulesReviewStatus incomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return this;
    }

    @Nonnull
    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    public V1SubjectRulesReviewStatus nonResourceRules(List<V1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public V1SubjectRulesReviewStatus addNonResourceRulesItem(V1NonResourceRule nonResourceRulesItem) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<V1NonResourceRule>();
        }
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    @Nonnull
    public List<V1NonResourceRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<V1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public V1SubjectRulesReviewStatus resourceRules(List<V1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1SubjectRulesReviewStatus addResourceRulesItem(V1ResourceRule resourceRulesItem) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<V1ResourceRule>();
        }
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @Nonnull
    public List<V1ResourceRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<V1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SubjectRulesReviewStatus v1SubjectRulesReviewStatus = (V1SubjectRulesReviewStatus)o;
        return Objects.equals(this.evaluationError, v1SubjectRulesReviewStatus.evaluationError) && Objects.equals(this.incomplete, v1SubjectRulesReviewStatus.incomplete) && Objects.equals(this.nonResourceRules, v1SubjectRulesReviewStatus.nonResourceRules) && Objects.equals(this.resourceRules, v1SubjectRulesReviewStatus.resourceRules);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationError, this.incomplete, this.nonResourceRules, this.resourceRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SubjectRulesReviewStatus {\n");
        sb.append("    evaluationError: ").append(this.toIndentedString(this.evaluationError)).append("\n");
        sb.append("    incomplete: ").append(this.toIndentedString(this.incomplete)).append("\n");
        sb.append("    nonResourceRules: ").append(this.toIndentedString(this.nonResourceRules)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1SubjectRulesReviewStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1SubjectRulesReviewStatus` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVALUATION_ERROR) != null && !jsonObj.get(SERIALIZED_NAME_EVALUATION_ERROR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EVALUATION_ERROR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `evaluationError` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVALUATION_ERROR).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_RULES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `nonResourceRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_RULES).toString()));
        }
        JsonArray jsonArraynonResourceRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_NON_RESOURCE_RULES);
        for (int i = 0; i < jsonArraynonResourceRules.size(); ++i) {
            V1NonResourceRule.validateJsonObject(jsonArraynonResourceRules.get(i).getAsJsonObject());
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_RULES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_RULES).toString()));
        }
        JsonArray jsonArrayresourceRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCE_RULES);
        for (int i = 0; i < jsonArrayresourceRules.size(); ++i) {
            V1ResourceRule.validateJsonObject(jsonArrayresourceRules.get(i).getAsJsonObject());
        }
    }

    public static V1SubjectRulesReviewStatus fromJson(String jsonString) throws IOException {
        return (V1SubjectRulesReviewStatus)JSON.getGson().fromJson(jsonString, V1SubjectRulesReviewStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EVALUATION_ERROR);
        openapiFields.add(SERIALIZED_NAME_INCOMPLETE);
        openapiFields.add(SERIALIZED_NAME_NON_RESOURCE_RULES);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_RULES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_INCOMPLETE);
        openapiRequiredFields.add(SERIALIZED_NAME_NON_RESOURCE_RULES);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_RULES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1SubjectRulesReviewStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1SubjectRulesReviewStatus.class));
            return new TypeAdapter<V1SubjectRulesReviewStatus>(){

                public void write(JsonWriter out, V1SubjectRulesReviewStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1SubjectRulesReviewStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1SubjectRulesReviewStatus.validateJsonObject(jsonObj);
                    return (V1SubjectRulesReviewStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

