/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Overhead;
import io.kubernetes.client.openapi.models.V1Scheduling;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1RuntimeClass
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_HANDLER = "handler";
    @SerializedName(value="handler")
    private String handler;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_OVERHEAD = "overhead";
    @SerializedName(value="overhead")
    private V1Overhead overhead;
    public static final String SERIALIZED_NAME_SCHEDULING = "scheduling";
    @SerializedName(value="scheduling")
    private V1Scheduling scheduling;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1RuntimeClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1RuntimeClass handler(String handler) {
        this.handler = handler;
        return this;
    }

    @Nonnull
    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public V1RuntimeClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1RuntimeClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1RuntimeClass overhead(V1Overhead overhead) {
        this.overhead = overhead;
        return this;
    }

    @Nullable
    public V1Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(V1Overhead overhead) {
        this.overhead = overhead;
    }

    public V1RuntimeClass scheduling(V1Scheduling scheduling) {
        this.scheduling = scheduling;
        return this;
    }

    @Nullable
    public V1Scheduling getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(V1Scheduling scheduling) {
        this.scheduling = scheduling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RuntimeClass v1RuntimeClass = (V1RuntimeClass)o;
        return Objects.equals(this.apiVersion, v1RuntimeClass.apiVersion) && Objects.equals(this.handler, v1RuntimeClass.handler) && Objects.equals(this.kind, v1RuntimeClass.kind) && Objects.equals(this.metadata, v1RuntimeClass.metadata) && Objects.equals(this.overhead, v1RuntimeClass.overhead) && Objects.equals(this.scheduling, v1RuntimeClass.scheduling);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.handler, this.kind, this.metadata, this.overhead, this.scheduling);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1RuntimeClass {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    handler: ").append(this.toIndentedString(this.handler)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    overhead: ").append(this.toIndentedString(this.overhead)).append("\n");
        sb.append("    scheduling: ").append(this.toIndentedString(this.scheduling)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1RuntimeClass is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1RuntimeClass` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_HANDLER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `handler` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HANDLER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_OVERHEAD) != null && !jsonObj.get(SERIALIZED_NAME_OVERHEAD).isJsonNull()) {
            V1Overhead.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_OVERHEAD));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULING) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULING).isJsonNull()) {
            V1Scheduling.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCHEDULING));
        }
    }

    public static V1RuntimeClass fromJson(String jsonString) throws IOException {
        return (V1RuntimeClass)JSON.getGson().fromJson(jsonString, V1RuntimeClass.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_HANDLER);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_OVERHEAD);
        openapiFields.add(SERIALIZED_NAME_SCHEDULING);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_HANDLER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1RuntimeClass.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1RuntimeClass.class));
            return new TypeAdapter<V1RuntimeClass>(){

                public void write(JsonWriter out, V1RuntimeClass value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1RuntimeClass read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1RuntimeClass.validateJsonObject(jsonObj);
                    return (V1RuntimeClass)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

