/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha2DriverRequests;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParametersReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimParameters defines resource requests for a ResourceClaim in an in-tree format understood by Kubernetes.")
public class V1alpha2ResourceClaimParameters
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DRIVER_REQUESTS = "driverRequests";
    @SerializedName(value="driverRequests")
    private List<V1alpha2DriverRequests> driverRequests = null;
    public static final String SERIALIZED_NAME_GENERATED_FROM = "generatedFrom";
    @SerializedName(value="generatedFrom")
    private V1alpha2ResourceClaimParametersReference generatedFrom;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_SHAREABLE = "shareable";
    @SerializedName(value="shareable")
    private Boolean shareable;

    public V1alpha2ResourceClaimParameters apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha2ResourceClaimParameters driverRequests(List<V1alpha2DriverRequests> driverRequests) {
        this.driverRequests = driverRequests;
        return this;
    }

    public V1alpha2ResourceClaimParameters addDriverRequestsItem(V1alpha2DriverRequests driverRequestsItem) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList<V1alpha2DriverRequests>();
        }
        this.driverRequests.add(driverRequestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DriverRequests describes all resources that are needed for the allocated claim. A single claim may use resources coming from different drivers. For each driver, this array has at most one entry which then may have one or more per-driver requests.  May be empty, in which case the claim can always be allocated.")
    public List<V1alpha2DriverRequests> getDriverRequests() {
        return this.driverRequests;
    }

    public void setDriverRequests(List<V1alpha2DriverRequests> driverRequests) {
        this.driverRequests = driverRequests;
    }

    public V1alpha2ResourceClaimParameters generatedFrom(V1alpha2ResourceClaimParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2ResourceClaimParametersReference getGeneratedFrom() {
        return this.generatedFrom;
    }

    public void setGeneratedFrom(V1alpha2ResourceClaimParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    public V1alpha2ResourceClaimParameters kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceClaimParameters metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha2ResourceClaimParameters shareable(Boolean shareable) {
        this.shareable = shareable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shareable indicates whether the allocated claim is meant to be shareable by multiple consumers at the same time.")
    public Boolean getShareable() {
        return this.shareable;
    }

    public void setShareable(Boolean shareable) {
        this.shareable = shareable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimParameters v1alpha2ResourceClaimParameters = (V1alpha2ResourceClaimParameters)o;
        return Objects.equals(this.apiVersion, v1alpha2ResourceClaimParameters.apiVersion) && Objects.equals(this.driverRequests, v1alpha2ResourceClaimParameters.driverRequests) && Objects.equals(this.generatedFrom, v1alpha2ResourceClaimParameters.generatedFrom) && Objects.equals(this.kind, v1alpha2ResourceClaimParameters.kind) && Objects.equals(this.metadata, v1alpha2ResourceClaimParameters.metadata) && Objects.equals(this.shareable, v1alpha2ResourceClaimParameters.shareable);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverRequests, this.generatedFrom, this.kind, this.metadata, this.shareable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimParameters {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    driverRequests: ").append(this.toIndentedString(this.driverRequests)).append("\n");
        sb.append("    generatedFrom: ").append(this.toIndentedString(this.generatedFrom)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    shareable: ").append(this.toIndentedString(this.shareable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

