/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="VolumeResourceRequirements describes the storage resource requirements for a volume.")
public class V1VolumeResourceRequirements {
    public static final String SERIALIZED_NAME_LIMITS = "limits";
    @SerializedName(value="limits")
    private Map<String, Quantity> limits = null;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private Map<String, Quantity> requests = null;

    public V1VolumeResourceRequirements limits(Map<String, Quantity> limits) {
        this.limits = limits;
        return this;
    }

    public V1VolumeResourceRequirements putLimitsItem(String key, Quantity limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Quantity>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/")
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, Quantity> limits) {
        this.limits = limits;
    }

    public V1VolumeResourceRequirements requests(Map<String, Quantity> requests) {
        this.requests = requests;
        return this;
    }

    public V1VolumeResourceRequirements putRequestsItem(String key, Quantity requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, Quantity>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/")
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, Quantity> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeResourceRequirements v1VolumeResourceRequirements = (V1VolumeResourceRequirements)o;
        return Objects.equals(this.limits, v1VolumeResourceRequirements.limits) && Objects.equals(this.requests, v1VolumeResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.limits, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeResourceRequirements {\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

