/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="QueuingConfiguration holds the configuration parameters for queuing")
public class V1alpha1QueuingConfiguration {
    public static final String SERIALIZED_NAME_HAND_SIZE = "handSize";
    @SerializedName(value="handSize")
    private Integer handSize;
    public static final String SERIALIZED_NAME_QUEUE_LENGTH_LIMIT = "queueLengthLimit";
    @SerializedName(value="queueLengthLimit")
    private Integer queueLengthLimit;
    public static final String SERIALIZED_NAME_QUEUES = "queues";
    @SerializedName(value="queues")
    private Integer queues;

    public V1alpha1QueuingConfiguration handSize(Integer handSize) {
        this.handSize = handSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.")
    public Integer getHandSize() {
        return this.handSize;
    }

    public void setHandSize(Integer handSize) {
        this.handSize = handSize;
    }

    public V1alpha1QueuingConfiguration queueLengthLimit(Integer queueLengthLimit) {
        this.queueLengthLimit = queueLengthLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.")
    public Integer getQueueLengthLimit() {
        return this.queueLengthLimit;
    }

    public void setQueueLengthLimit(Integer queueLengthLimit) {
        this.queueLengthLimit = queueLengthLimit;
    }

    public V1alpha1QueuingConfiguration queues(Integer queues) {
        this.queues = queues;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.")
    public Integer getQueues() {
        return this.queues;
    }

    public void setQueues(Integer queues) {
        this.queues = queues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1QueuingConfiguration v1alpha1QueuingConfiguration = (V1alpha1QueuingConfiguration)o;
        return Objects.equals(this.handSize, v1alpha1QueuingConfiguration.handSize) && Objects.equals(this.queueLengthLimit, v1alpha1QueuingConfiguration.queueLengthLimit) && Objects.equals(this.queues, v1alpha1QueuingConfiguration.queues);
    }

    public int hashCode() {
        return Objects.hash(this.handSize, this.queueLengthLimit, this.queues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1QueuingConfiguration {\n");
        sb.append("    handSize: ").append(this.toIndentedString(this.handSize)).append("\n");
        sb.append("    queueLengthLimit: ").append(this.toIndentedString(this.queueLengthLimit)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

