/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.servlet.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class BufferedRequestWrapper
extends HttpServletRequestWrapper {
    private String bufferedRequest;

    public BufferedRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.bufferedRequest = this.getInputString(request);
    }

    private String getInputString(HttpServletRequest request) throws IOException {
        String requestBody;
        if (request.getInputStream() == null) {
            return null;
        }
        Scanner s = new Scanner((InputStream)request.getInputStream(), "UTF-8").useDelimiter("\\A");
        String string = requestBody = s.hasNext() ? s.next() : "";
        if (requestBody == null || requestBody.isEmpty()) {
            return "";
        }
        return requestBody;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.bufferedRequest == null) {
            return null;
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bufferedRequest.getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }
}

