/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.invoker.internal;

import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiMediaType {
    private static Logger log = LoggerFactory.getLogger(JsonApiMediaType.class);
    public static final String APPLICATION_JSON_API = "application/vnd.api+json;charset=UTF-8";
    public static final MediaType APPLICATION_JSON_API_TYPE = MediaType.create((String)"application", (String)"vnd.api+json").withCharset(StandardCharsets.UTF_8);
    private static final String WILDCARD = "*";

    public static boolean isCompatibleMediaType(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (WILDCARD.equals(mediaType.type())) {
            return true;
        }
        if (MediaType.ANY_APPLICATION_TYPE.type().equalsIgnoreCase(mediaType.type())) {
            log.debug("application mediaType : {}", (Object)mediaType);
            if (WILDCARD.equals(mediaType.subtype())) {
                return true;
            }
            if (APPLICATION_JSON_API_TYPE.subtype().equalsIgnoreCase(mediaType.subtype())) {
                log.debug("application mediaType having json api subtype : {}", (Object)mediaType);
                return true;
            }
        }
        return false;
    }

    private JsonApiMediaType() {
    }
}

