/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.resource.registry;

import io.katharsis.resource.registry.ResourceLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultiResourceLookup
implements ResourceLookup {
    private Collection<ResourceLookup> lookups;

    public MultiResourceLookup(List<ResourceLookup> lookups) {
        this.lookups = lookups;
    }

    @Override
    public Set<Class<?>> getResourceClasses() {
        HashSet set = new HashSet();
        for (ResourceLookup lookup : this.lookups) {
            set.addAll(lookup.getResourceClasses());
        }
        return set;
    }

    @Override
    public Set<Class<?>> getResourceRepositoryClasses() {
        HashSet set = new HashSet();
        for (ResourceLookup lookup : this.lookups) {
            set.addAll(lookup.getResourceRepositoryClasses());
        }
        return set;
    }

    public static ResourceLookup newInstance(ResourceLookup ... lookups) {
        ArrayList<ResourceLookup> list = new ArrayList<ResourceLookup>();
        for (ResourceLookup lookup : lookups) {
            if (lookup == null) continue;
            list.add(lookup);
        }
        return new MultiResourceLookup(list);
    }
}

