/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.katharsis.core.internal.resource.NullableSerializer;
import io.katharsis.core.internal.resource.RelationshipDataDeserializer;
import io.katharsis.resource.LinksContainer;
import io.katharsis.resource.MetaContainer;
import io.katharsis.resource.Resource;
import io.katharsis.resource.ResourceIdentifier;
import io.katharsis.utils.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Relationship
implements MetaContainer,
LinksContainer {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=NullableSerializer.class)
    @JsonDeserialize(using=RelationshipDataDeserializer.class)
    private Nullable<Object> data = Nullable.empty();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ObjectNode links;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ObjectNode meta;

    public Relationship() {
    }

    public Relationship(ResourceIdentifier resourceId) {
        this.data = Nullable.of(resourceId);
    }

    public Relationship(List<ResourceIdentifier> resourceIds) {
        this.data = Nullable.of(resourceIds);
    }

    @Override
    public ObjectNode getLinks() {
        return this.links;
    }

    @Override
    public void setLinks(ObjectNode links) {
        this.links = links;
    }

    @Override
    public ObjectNode getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(ObjectNode meta) {
        this.meta = meta;
    }

    public Nullable<Object> getData() {
        return this.data;
    }

    @JsonIgnore
    public Nullable<ResourceIdentifier> getSingleData() {
        return this.data;
    }

    @JsonIgnore
    public Nullable<List<ResourceIdentifier>> getCollectionData() {
        if (!this.data.isPresent()) {
            return Nullable.empty();
        }
        Object value = this.data.get();
        if (!(value instanceof Iterable)) {
            return Nullable.of(Collections.singletonList((ResourceIdentifier)value));
        }
        return Nullable.of((List)value);
    }

    public void setData(Nullable<Object> data) {
        Object object;
        Collection col;
        Object value;
        if (data == null) {
            throw new NullPointerException("make use of Nullable");
        }
        if (data.isPresent() && ((value = data.get()) instanceof Collection ? !(col = (Collection)value).isEmpty() && (object = col.iterator().next()) instanceof Resource : value != null && value instanceof Resource)) {
            throw new IllegalArgumentException();
        }
        this.data = data;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.meta, other.meta) && Objects.equals(this.links, other.links);
    }
}

