/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.registry;

import io.katharsis.core.internal.registry.ResourceRegistryImpl;
import io.katharsis.core.internal.repository.information.ResourceRepositoryInformationImpl;
import io.katharsis.legacy.locator.JsonServiceLocator;
import io.katharsis.legacy.registry.DefaultResourceInformationBuilderContext;
import io.katharsis.legacy.registry.RepositoryEntryBuilderFacade;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.information.ResourceInformationBuilder;
import io.katharsis.resource.registry.DefaultResourceLookup;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceEntry;
import io.katharsis.resource.registry.ResourceLookup;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ResponseRelationshipEntry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ResourceRegistryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRegistryBuilder.class);
    private final ResourceInformationBuilder resourceInformationBuilder;
    private final RepositoryEntryBuilderFacade repositoryEntryBuilder;

    public ResourceRegistryBuilder(ModuleRegistry moduleRegistry, JsonServiceLocator jsonServiceLocator, ResourceInformationBuilder resourceInformationBuilder) {
        this.resourceInformationBuilder = resourceInformationBuilder;
        this.repositoryEntryBuilder = new RepositoryEntryBuilderFacade(moduleRegistry, jsonServiceLocator);
        DefaultResourceInformationBuilderContext context = new DefaultResourceInformationBuilderContext(resourceInformationBuilder, moduleRegistry.getTypeParser());
        resourceInformationBuilder.init(context);
    }

    public ResourceRegistry build(String packageName, ModuleRegistry moduleRegistry, ServiceUrlProvider serviceUrlProvider) {
        return this.build(new DefaultResourceLookup(packageName), moduleRegistry, serviceUrlProvider);
    }

    public ResourceRegistry build(ResourceLookup resourceLookup, ModuleRegistry moduleRegistry, ServiceUrlProvider serviceUrl) {
        Set<Class<?>> jsonApiResources = resourceLookup.getResourceClasses();
        HashSet<ResourceInformation> resourceInformationSet = new HashSet<ResourceInformation>(jsonApiResources.size());
        for (Class<?> clazz : jsonApiResources) {
            resourceInformationSet.add(this.resourceInformationBuilder.build(clazz));
            LOGGER.trace("{} registered as a resource", clazz);
        }
        HashSet<RegistryEntry> registryEntries = new HashSet<RegistryEntry>(resourceInformationSet.size());
        for (ResourceInformation resourceInformation : resourceInformationSet) {
            Class<?> resourceClass = resourceInformation.getResourceClass();
            ResourceEntry resourceEntry = this.repositoryEntryBuilder.buildResourceRepository(resourceLookup, resourceClass);
            LOGGER.trace("{} has a resource repository {}", resourceInformation.getResourceClass(), (Object)resourceEntry);
            List<ResponseRelationshipEntry> relationshipEntries = this.repositoryEntryBuilder.buildRelationshipRepositories(resourceLookup, resourceClass);
            LOGGER.trace("{} has relationship repositories {}", resourceInformation.getResourceClass(), relationshipEntries);
            ResourceRepositoryInformationImpl repositoryInformation = new ResourceRepositoryInformationImpl(null, resourceInformation.getResourceType(), resourceInformation);
            registryEntries.add(new RegistryEntry(repositoryInformation, resourceEntry, relationshipEntries));
        }
        ResourceRegistryImpl resourceRegistryImpl = new ResourceRegistryImpl(moduleRegistry, serviceUrl);
        for (RegistryEntry registryEntry : registryEntries) {
            Class<?> resourceClass = registryEntry.getResourceInformation().getResourceClass();
            RegistryEntry registryEntryParent = this.findParent(resourceClass, registryEntries);
            registryEntry.setParentRegistryEntry(registryEntryParent);
            resourceRegistryImpl.addEntry(resourceClass, registryEntry);
        }
        return resourceRegistryImpl;
    }

    private RegistryEntry findParent(Class<?> resourceClass, Set<RegistryEntry> registryEntries) {
        RegistryEntry foundRegistryEntry = null;
        block0: for (Class<?> currentClass = resourceClass.getSuperclass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (RegistryEntry availableRegistryEntry : registryEntries) {
                if (!availableRegistryEntry.getResourceInformation().getResourceClass().equals(currentClass)) continue;
                foundRegistryEntry = availableRegistryEntry;
                break block0;
            }
        }
        return foundRegistryEntry;
    }
}

