/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.registry;

import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.legacy.internal.AnnotatedRelationshipRepositoryAdapter;
import io.katharsis.legacy.internal.ParametersFactory;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.legacy.registry.RepositoryInstanceBuilder;
import io.katharsis.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.resource.registry.ResponseRelationshipEntry;
import io.katharsis.utils.Optional;

public class AnnotatedRelationshipEntryBuilder
implements ResponseRelationshipEntry {
    private RepositoryInstanceBuilder repositoryInstanceBuilder;
    private ModuleRegistry moduleRegistry;

    public AnnotatedRelationshipEntryBuilder(ModuleRegistry moduleRegistry, RepositoryInstanceBuilder repositoryInstanceBuilder) {
        this.moduleRegistry = moduleRegistry;
        this.repositoryInstanceBuilder = repositoryInstanceBuilder;
    }

    @Override
    public Class<?> getTargetAffiliation() {
        Optional<JsonApiRelationshipRepository> annotation = ClassUtils.getAnnotation(this.repositoryInstanceBuilder.getRepositoryClass(), JsonApiRelationshipRepository.class);
        if (annotation.isPresent()) {
            return annotation.get().target();
        }
        throw new IllegalArgumentException(String.format("Class %s must be annotated with @JsonApiRelationshipRepository", this.repositoryInstanceBuilder.getClass().getName()));
    }

    public AnnotatedRelationshipRepositoryAdapter build(RepositoryMethodParameterProvider parameterProvider) {
        return new AnnotatedRelationshipRepositoryAdapter(this.repositoryInstanceBuilder.buildRepository(), new ParametersFactory(this.moduleRegistry, parameterProvider));
    }

    public String toString() {
        return "AnnotatedRelationshipEntryBuilder{repositoryInstanceBuilder=" + this.repositoryInstanceBuilder + '}';
    }
}

